/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_1.ioutils;

import com.calpano.kgif.v1_0_1.gen.Attribute;
import com.calpano.kgif.v1_0_1.gen.Content;
import com.calpano.kgif.v1_0_1.gen.Graph;
import com.calpano.kgif.v1_0_1.gen.Kgif;
import com.calpano.kgif.v1_0_1.gen.Link;
import com.calpano.kgif.v1_0_1.gen.Metadata;
import com.calpano.kgif.v1_0_1.gen.Node;
import com.calpano.kgif.v1_0_1.gen.Property;
import java.util.List;

public class KgifDump {
    public static void dump(Kgif kgif) {
        System.out.println(kgif.getHeader().getSchemaVersionNumber());
        System.out.println(kgif.getHeader().getSchemaVersionDate());
        Graph graph = kgif.getGraph();
        List<Object> list = graph.getNodeOrLinkOrProperty();
        for (Object o : list) {
            if (o instanceof Node) {
                KgifDump.dump((Node)o);
            }
            if (o instanceof Link) {
                KgifDump.dump((Link)o);
            }
            if (!(o instanceof Property)) continue;
            KgifDump.dump((Property)o);
        }
    }

    private static void dump(Link link) {
        System.out.println("LINK [" + link.getId() + "] " + link.getFrom() + "--(" + link.getType() + ")-->" + link.getTo());
        KgifDump.dump(link.getMetadata());
    }

    private static void dump(Property property) {
        System.out.println("PROPERTY [" + property.getId() + "] " + property.getKey() + "= '" + property.getContent().getContent() + "'");
        KgifDump.dump(property.getMetadata());
    }

    static void dump(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        if (metadata.getAttribute() == null) {
            return;
        }
        for (Attribute att : metadata.getAttribute()) {
            System.out.println(att.getName() + " = " + att.getContent());
        }
    }

    private static void dump(Node node) {
        System.out.println("NODE [" + node.getId() + "] '" + node.getLabel().getContent() + "'");
        KgifDump.dump(node.getMetadata());
        KgifDump.dump(node.getContent());
    }

    private static void dump(Content content) {
        if (content != null) {
            System.out.println("CONTENT " + content.getContentType());
            System.out.println("'" + content.getContent() + "'");
        }
    }

    public static void dump(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            KgifDump.dump(node);
        } else if (o instanceof Link) {
            Link link = (Link)o;
            KgifDump.dump(link);
        } else {
            System.out.println(o.toString());
        }
    }
}

