/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_0.read;

import com.calpano.kgif.v1_0_0.IEntityHandler;
import com.calpano.kgif.v1_0_0.KgifJob;
import com.calpano.kgif.v1_0_0.gen.Content;
import com.calpano.kgif.v1_0_0.gen.Header;
import com.calpano.kgif.v1_0_0.gen.Label;
import com.calpano.kgif.v1_0_0.gen.Link;
import com.calpano.kgif.v1_0_0.gen.Metadata;
import com.calpano.kgif.v1_0_0.gen.Node;
import com.calpano.kgif.v1_0_0.ioutils.KgifDump;
import com.calpano.kgif.v1_0_0.read.KgifReadWriteException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public final class ValidatingEntityHandler
implements IEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(ValidatingEntityHandler.class);
    private final Map<String, Object> ids = new HashMap<String, Object>();
    private boolean inDocument = false;
    private boolean inGraph = false;
    private final KgifJob job;
    private final Set<String> link_oIds = new HashSet<String>();
    private final Set<String> link_pIds = new HashSet<String>();
    private final Set<String> link_sIds = new HashSet<String>();
    private HashSet<String> allowedContentTypes = null;
    private boolean throwExceptions;
    private boolean valid = true;

    public ValidatingEntityHandler(KgifJob job) {
        this.job = job;
    }

    @Override
    public void close() throws IOException {
    }

    public Set<String> getMissingNodeIds() {
        HashSet<String> idsUsedInLinks = new HashSet<String>();
        idsUsedInLinks.addAll(this.link_sIds);
        idsUsedInLinks.addAll(this.link_pIds);
        idsUsedInLinks.addAll(this.link_oIds);
        idsUsedInLinks.removeAll(this.ids.keySet());
        return idsUsedInLinks;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void markAsInvalid(String parseLocation, String msg) {
        this.valid = false;
        log.warn(msg + " at " + parseLocation);
        if (this.throwExceptions) {
            throw new KgifReadWriteException("Invalid: " + msg, parseLocation);
        }
    }

    @Override
    public void onDocumentEnd(String parseLocation) throws IOException {
        if (this.inGraph) {
            throw new KgifReadWriteException("Still in a graph - close it", parseLocation);
        }
        if (!this.inDocument) {
            throw new KgifReadWriteException("Not in a document - start it", parseLocation);
        }
        this.inDocument = false;
    }

    @Override
    public void onDocumentStart(String parseLocation) throws IOException {
        this.inDocument = true;
    }

    @Override
    public void onGraphEnd(String parseLocation) {
        if (!this.inGraph) {
            throw new KgifReadWriteException("Not in a graph - start it", parseLocation);
        }
        this.inGraph = false;
        if (this.job.isRequireUseOnlyIdsWithEntities()) {
            this.validateLinksUseKnownNodes();
        }
    }

    @Override
    public void onGraphStart(String parseLocation, Metadata metadata) {
        this.inGraph = true;
    }

    @Override
    public void onHeader(String parseLocation, Header header) {
        if (!this.inDocument) {
            throw new KgifReadWriteException("Not in a document- start it", parseLocation);
        }
        if (this.inGraph) {
            throw new KgifReadWriteException("Already started a graph - put header before", parseLocation);
        }
        this.validateSomeValue("header.schemaVersionDate", header.getSchemaVersionDate());
        this.validateSomeValue("header.schemaVersionNumber", header.getSchemaVersionNumber());
    }

    @Override
    public void onLink(String parseLocation, Link link) {
        if (link.getId() != null) {
            this.validateIdNotUsedYet(link.getId(), link);
        }
        this.link_sIds.add(link.getFrom());
        this.link_pIds.add(link.getType());
        this.link_oIds.add(link.getTo());
    }

    @Override
    public void onNode(String parseLocation, Node node) {
        Content content;
        this.validateIdNotUsedYet(node.getId(), node);
        Label label = node.getLabel();
        if (this.job.isRequireNodeLabels() && label == null) {
            this.markAsInvalid(parseLocation, "Node with id '" + node.getId() + "' has no label.");
        }
        if (label != null) {
            if (label.getvalue() == null) {
                this.markAsInvalid(parseLocation, "Node with id '" + node.getId() + "' has no label content.");
            }
            if (label.getContentType() == null) {
                this.markAsInvalid(parseLocation, "Node with id '" + node.getId() + "' has no label content type.");
            } else {
                String contentType = label.getContentType();
                this.validateContentType(parseLocation, contentType);
            }
        }
        if ((content = node.getContent()) != null) {
            if (content.getContentType() == null) {
                this.markAsInvalid(parseLocation, "Node with id '" + node.getId() + "' has no content content type.");
            } else {
                String contentType = content.getContentType();
                this.validateContentType(parseLocation, contentType);
            }
        }
    }

    public void setAllowedContentTypes(Collection<String> contentTypeStrings) {
        if (contentTypeStrings != null) {
            this.allowedContentTypes = new HashSet();
            this.allowedContentTypes.addAll(contentTypeStrings);
        } else {
            this.allowedContentTypes = null;
        }
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    private void validateContentType(String parseLocation, String contentType) {
        if (this.allowedContentTypes != null && !this.allowedContentTypes.contains(contentType)) {
            this.markAsInvalid(parseLocation, "Content type not set as allowed type: '" + contentType + "'");
        }
    }

    private void validateIdNotUsedYet(String id, Object o) {
        Object existing = this.ids.put(id, o);
        if (existing != null) {
            System.out.println("Existing entity: ");
            KgifDump.dump(existing);
            this.markAsInvalid("document", "Invalid, id '" + id + "' was already used for another element ");
        }
    }

    private void validateLinksUseKnownNodes() {
        Set<String> missingIds = this.getMissingNodeIds();
        if (!missingIds.isEmpty()) {
            this.markAsInvalid("all", "Found ids used in links but not defined as entites (like a 404). Missing ids are " + Iterators.toText(missingIds));
        }
    }

    private void validateSomeValue(String parseLocation, String s) {
        if (s == null || s.length() == 0) {
            this.markAsInvalid(parseLocation, "Invalid, value is missing");
        }
    }
}

