/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_0.read;

import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.IFileFormat;
import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.util.XmlReaderTools;
import com.calpano.kgif.v1_0_0.IEntityHandler;
import com.calpano.kgif.v1_0_0.gen.Header;
import com.calpano.kgif.v1_0_0.gen.Kgif;
import com.calpano.kgif.v1_0_0.gen.Link;
import com.calpano.kgif.v1_0_0.gen.Metadata;
import com.calpano.kgif.v1_0_0.gen.Node;
import com.calpano.kgif.v1_0_0.read.IKgifImporter;
import com.calpano.kgif.v1_0_0.read.KgifReadWriteException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifReader
implements IKgifImporter,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KgifReader.class);
    private IEntityHandler entityHandler;
    private IStreamProcessProgressReporter progress;
    private Reader reader;
    private String sourceName;
    private Unmarshaller unmarshaller;

    private static String parseLocation(XMLStreamReader xmlreader) {
        return KgifReader.parseLocation(xmlreader.getLocation());
    }

    private static String parseLocation(Location location) {
        if (location == null) {
            return "n/a";
        }
        return location.getLineNumber() + ":" + location.getColumnNumber();
    }

    private static String parseLocation(XMLStreamException e) {
        return KgifReader.parseLocation(e.getLocation());
    }

    public KgifReader(Reader reader, IEntityHandler entityHandler) {
        try {
            this.setReader(reader);
        }
        catch (JAXBException e) {
            throw new KgifReadWriteException("Internal Error", "beforeDocumentStart", e);
        }
        this.setEntityHandler(entityHandler);
    }

    @Override
    public IFileFormat getFileFormat() {
        return FileFormats.KGIF_1_1_0;
    }

    private void progress(String progressMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Progress: " + progressMessage);
        }
        if (this.progress != null) {
            this.progress.reportProgress(progressMessage);
        }
    }

    public void read() throws KgifReadWriteException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlreader = null;
        try {
            xmlreader = xmlInputFactory.createXMLStreamReader(this.reader);
            XmlReaderTools.skipEvents(xmlreader, 11, 7, 5, 3);
            this.entityHandler.onDocumentStart(KgifReader.parseLocation(xmlreader));
            this.progress("Found document start");
            XmlReaderTools.skipUntilElementStart(xmlreader, null, "header");
            Header header = (Header)this.unmarshaller.unmarshal(xmlreader, Header.class).getValue();
            this.entityHandler.onHeader(KgifReader.parseLocation(xmlreader), header);
            this.progress("Parsed header");
            XmlReaderTools.skipUntilElementStart(xmlreader, null, "graph");
            this.progress("Graph start");
            XmlReaderTools.skipUntilEvent(xmlreader, 1);
            if (xmlreader.getLocalName() == "metadata") {
                Metadata metadata = (Metadata)this.unmarshaller.unmarshal(xmlreader, Metadata.class).getValue();
                System.out.println("Now at " + xmlreader.getLocation().getLineNumber() + ":" + xmlreader.getLocation().getColumnNumber() + " = " + xmlreader.getLocation().getCharacterOffset());
                this.entityHandler.onGraphStart(KgifReader.parseLocation(xmlreader), metadata);
            } else {
                this.entityHandler.onGraphStart(KgifReader.parseLocation(xmlreader), null);
            }
            long nodes = 0L;
            long links = 0L;
            String name = "";
            do {
                boolean stats = false;
                log.trace("Parsing at line:col " + KgifReader.parseLocation(xmlreader) + " = char " + xmlreader.getLocation().getCharacterOffset());
                if (!XmlReaderTools.skipUntilElementStart(xmlreader, "graph", "node", "link")) break;
                name = xmlreader.getLocalName();
                if (name.equals("node")) {
                    JAXBElement unNode = this.unmarshaller.unmarshal(xmlreader, Node.class);
                    Node node = (Node)unNode.getValue();
                    this.entityHandler.onNode(KgifReader.parseLocation(xmlreader), node);
                    if (++nodes % 1000L == 0L) {
                        stats = true;
                    }
                } else {
                    assert (name.equals("link"));
                    Link link = (Link)this.unmarshaller.unmarshal(xmlreader, Link.class).getValue();
                    this.entityHandler.onLink(KgifReader.parseLocation(xmlreader), link);
                    if (++links % 1000L == 0L) {
                        stats = true;
                    }
                }
                if (!stats) continue;
                this.progress("Read " + nodes + " nodes and " + links + " links...");
            } while (name.equals("node") || name.equals("link"));
            XmlReaderTools.skipUntilElementEnd(xmlreader, "graph");
            this.progress("Graph end");
            this.entityHandler.onGraphEnd(KgifReader.parseLocation(xmlreader));
            this.progress("Document end");
            this.entityHandler.onDocumentEnd(KgifReader.parseLocation(xmlreader));
            xmlreader.close();
        }
        catch (XMLStreamException e) {
            throw new KgifReadWriteException("Internal Error", "beforeDocumentStart/" + KgifReader.parseLocation(e), e);
        }
        catch (JAXBException e) {
            throw new KgifReadWriteException("Internal Error", xmlreader != null ? KgifReader.parseLocation(xmlreader) : "n/a", e);
        }
    }

    @Override
    public void read(Reader r) throws IOException {
        try {
            this.setReader(r);
            this.read();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error", e);
        }
    }

    @Override
    public void setEntityHandler(IEntityHandler entityHandler) {
        this.entityHandler = entityHandler;
    }

    @Override
    public void setProgressHandler(IStreamProcessProgressReporter progress) {
        this.progress = progress;
    }

    private void setReader(Reader r) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kgif.class});
        this.unmarshaller = context.createUnmarshaller();
        this.reader = r;
    }

    @Override
    public void setSourceName(String sourceFileName) {
        this.sourceName = sourceFileName;
    }

    @Override
    public void close() throws IOException {
        this.entityHandler.close();
        this.reader.close();
    }
}

