/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_0.ioutils;

import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.v1_0_0.IEntityHandler;
import com.calpano.kgif.v1_0_0.gen.Header;
import com.calpano.kgif.v1_0_0.gen.Link;
import com.calpano.kgif.v1_0_0.gen.Metadata;
import com.calpano.kgif.v1_0_0.gen.Node;
import com.calpano.kgif.v1_0_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_0_0.read.KgifReader;
import com.calpano.kgif.v1_0_0.write.KgifWrites;
import com.calpano.kgif.v1_0_0.write.WritingEntityHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBException;

public class KgifTool {
    public static void transform(File kgifIn, File kgifOut, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        FileInputStream fis = new FileInputStream(kgifIn);
        kgifOut.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(kgifOut);
        KgifTool.transform(fis, fos, processor, progress);
        fos.close();
        fis.close();
    }

    public static void transform(InputStream is, OutputStream os, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        InputStreamReader r = new InputStreamReader(is, "utf-8");
        OutputStreamWriter w = new OutputStreamWriter(os, "utf-8");
        KgifTool.transform(r, w, processor, progress);
        ((Reader)r).close();
    }

    public static void transform(Reader r, Writer w, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        WritingEntityHandler weh = new WritingEntityHandler(w);
        processor.setBase(weh);
        try (KgifReader kr = new KgifReader(r, processor);){
            kr.setProgressHandler(progress);
            kr.read();
        }
        weh.close();
    }

    public static TransformingEntityHandler addMetadataAttributeToNodesAndLinks(final String attName, final String attValue) {
        return new TransformingEntityHandler(){

            @Override
            public void onLink(String parseLocation, Link link) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute(link, attName, attValue);
                this.base.onLink(parseLocation, link);
            }

            @Override
            public void onNode(String parseLocation, Node node) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute(node, attName, attValue);
                this.base.onNode(parseLocation, node);
            }
        };
    }

    public static class TransformingEntityHandler
    implements IEntityHandler {
        protected IEntityHandler base;

        public void setBase(IEntityHandler base) {
            this.base = base;
        }

        @Override
        public void close() throws IOException, KgifReadWriteException {
            this.base.close();
        }

        @Override
        public void onDocumentEnd(String parseLocation) throws IOException, KgifReadWriteException {
            this.base.onDocumentEnd(parseLocation);
        }

        @Override
        public void onDocumentStart(String parseLocation) throws IOException, KgifReadWriteException {
            this.base.onDocumentStart(parseLocation);
        }

        @Override
        public void onGraphEnd(String parseLocation) throws IOException, KgifReadWriteException {
            this.base.onGraphEnd(parseLocation);
        }

        @Override
        public void onGraphStart(String parseLocation, Metadata metadata) throws IOException, KgifReadWriteException {
            this.base.onGraphStart(parseLocation, metadata);
        }

        @Override
        public void onHeader(String parseLocation, Header header) throws IOException, KgifReadWriteException {
            this.base.onHeader(parseLocation, header);
        }

        @Override
        public void onLink(String parseLocation, Link link) throws IOException, KgifReadWriteException {
            this.base.onLink(parseLocation, link);
        }

        @Override
        public void onNode(String parseLocation, Node node) throws IOException, KgifReadWriteException {
            this.base.onNode(parseLocation, node);
        }
    }
}

