/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_0.ioutils;

import com.calpano.kgif.v1_0_0.IEntityHandler;
import com.calpano.kgif.v1_0_0.KgifJob;
import com.calpano.kgif.v1_0_0.gen.Label;
import com.calpano.kgif.v1_0_0.gen.Metadata;
import com.calpano.kgif.v1_0_0.gen.Node;
import com.calpano.kgif.v1_0_0.write.KgifWrites;
import java.io.IOException;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifRepairs {
    private static final Logger log = LoggerFactory.getLogger(KgifRepairs.class);

    public static void addMissingNodes(KgifJob job, Set<String> missingNodeIds, IEntityHandler eh) throws IOException {
        assert (missingNodeIds != null);
        log.info("Found nodeIds used in links but not defined as entities. Auto-creating them for " + missingNodeIds);
        for (String nodeId : missingNodeIds) {
            Node stubNode = new Node();
            stubNode.setId(nodeId);
            if (job.isRequireNodeLabels()) {
                Label label = new Label();
                label.setContentType("http://www.w3.org/2001/XMLSchema#string");
                label.setvalue(nodeId);
                stubNode.setLabel(label);
            }
            Metadata metadata = KgifWrites.createMetadata("comment", "repair: added node used in links but not declared");
            stubNode.setMetadata(metadata);
            eh.onNode("auto-creating nodes", stubNode);
        }
    }

    public static String repairContentType(String contentType) {
        if (contentType.equals("vocabulary-item-dummy")) {
            return "http://www.w3.org/2001/XMLSchema#string";
        }
        return contentType;
    }
}

