/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xydra.index.iterator.ITransformer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FutureUtils {
    private static final Logger log = LoggerFactory.getLogger(FutureUtils.class);

    /*
     * Loose catch block
     */
    public static <T> T waitFor(Future<T> t) {
        while (true) {
            try {
                return t.get();
            }
            catch (InterruptedException e) {
                log.warn("interrrupted while waiting for datastore get", (Throwable)e);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static <T> Future<T> createCompleted(final T value) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public T get() {
                return value;
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                return value;
            }
        };
    }

    public static class TransformingFuture<I, O>
    implements Future<O> {
        private final Future<I> in;
        private final ITransformer<I, O> transformer;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.in.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.in.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.in.isDone();
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            I inValue = this.in.get();
            return (O)this.transformer.transform(inValue);
        }

        @Override
        public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            I inValue = this.in.get(timeout, unit);
            return (O)this.transformer.transform(inValue);
        }

        public TransformingFuture(Future<I> in, ITransformer<I, O> transformer) {
            this.in = in;
            this.transformer = transformer;
        }
    }
}

