/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.HostUtils;

public class LocalLogConf {
    private static File localConfFile() {
        String hostname = HostUtils.getLocalHostname();
        if (hostname.endsWith(".local")) {
            hostname = hostname.substring(0, hostname.length() - ".local".length());
        }
        String dir = "./src/main/resources/";
        String ext = "-log4j.properties";
        File[] searchFiles = new File[]{new File("./src/main/resources/" + hostname.toLowerCase() + "-log4j.properties"), new File("./src/main/resources/" + HostUtils.getLocalUserName() + "-log4j.properties")};
        File f = null;
        StringBuilder helpMsg = new StringBuilder("System.out: Logging: Found no special log4j config for this host. Looked in locations: ");
        for (int i = 0; i < searchFiles.length; ++i) {
            if (searchFiles[i].exists()) {
                f = searchFiles[i];
                break;
            }
            helpMsg.append("\n'").append(searchFiles[i].getAbsolutePath()).append("', ");
        }
        if (f == null) {
            System.out.println(helpMsg);
            return null;
        }
        return f;
    }

    public static void configureLog4j() {
        File file = LocalLogConf.localConfFile();
        if (file == null) {
            return;
        }
        Properties props = new Properties();
        try {
            FileReader r = new FileReader(file);
            props.load(r);
            ((Reader)r).close();
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((Properties)props);
            System.out.println("System.out: Logging: Set local log config exclusively to settings from " + file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Logger log = LoggerFactory.getLogger(LocalLogConf.class);
        System.out.println("Logging to '" + log + "'");
        log.debug("Debug");
        log.info("Info");
        log.warn("Warn");
        System.out.println("E.g.: Add 'log4j.logger.com.calpano.favr.LocalLogConf=WARN' to your log conf file \n" + LocalLogConf.localConfFile().getAbsolutePath() + "\n" + "and you should see only WARN, no more DEBUG or INFO.");
    }
}

