/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.xydra.env.Env;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.SharedHtmlUtils;

public class DebugMode {
    private static boolean DEBUG_MODE = false;

    public static void restless(Restless restless, String prefix) {
        restless.addMethod("/debugmode", "GET", DebugMode.class, "index", true, new RestlessParameter[]{new RestlessParameter("mode", null)});
        DEBUG_MODE = Env.get().conf().getBoolean("DEBUG_MODE");
    }

    public static void index(String debugMode, HttpServletResponse res) throws IOException {
        if (debugMode != null) {
            boolean debug = Boolean.parseBoolean(debugMode);
            DebugMode.setDebug(debug);
        }
        Writer w = HtmlUtils.startHtmlPage((HttpServletResponse)res, (String)"Debug Mode", (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
        w.write("Debug mode is now " + DebugMode.on() + ". Set it to ");
        w.write(SharedHtmlUtils.link((String)"/admin/debugmode?mode=false", (String)"false"));
        w.write(" | ");
        w.write(SharedHtmlUtils.link((String)"/admin/debugmode?mode=true", (String)"true"));
        HtmlUtils.endHtmlPage((Writer)w);
    }

    public static boolean isOn() {
        return DEBUG_MODE;
    }

    @Deprecated
    public static boolean on() {
        return DEBUG_MODE;
    }

    public static void setDebug(boolean state) {
        DEBUG_MODE = state;
        Env.get().conf().set("DEBUG_MODE", (Object)state);
    }
}

