/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.xydra.annotations.LicenseBSD3Clause;

@LicenseBSD3Clause(yearOwner="2010, Zepheira LLC", dateRetrieved="2015-07-09")
public class CatInputStream
extends InputStream {
    private InputStream currentIs = null;
    private final Iterator<InputStream> isIt;
    private int streamNo = -1;

    public CatInputStream(Iterator<InputStream> isIt) throws IOException {
        this.isIt = isIt;
        this.peek();
    }

    @Override
    public int available() throws IOException {
        if (this.currentIs == null) {
            return 0;
        }
        return this.currentIs.available();
    }

    @Override
    public void close() throws IOException {
        if (this.currentIs != null) {
            this.currentIs.close();
        }
    }

    public int getStreamNo() {
        return this.streamNo;
    }

    private void peek() throws IOException {
        this.currentIs = this.isIt.next();
        ++this.streamNo;
    }

    @Override
    public int read() throws IOException {
        if (this.currentIs == null) {
            return -1;
        }
        int read = this.currentIs.read();
        if (read < 0) {
            this.currentIs.close();
            this.peek();
            return this.read();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentIs == null) {
            return -1;
        }
        int read = this.currentIs.read(b, off, len);
        if (read < 0) {
            this.currentIs.close();
            this.peek();
            return this.read(b, off, len);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.currentIs == null) {
            return -1L;
        }
        long read = super.skip(n);
        if (read < 0L) {
            this.currentIs.close();
            this.peek();
            return this.skip(n);
        }
        return read;
    }
}

