/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ArrayUtils {
    private static <T> T copyArrayGrowN(T array, Class<?> newArrayComponentType, int n) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + n);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return (T)newArray;
        }
        return (T)Array.newInstance(newArrayComponentType, n);
    }

    @SafeVarargs
    public static <T> T[] append(T[] array, T ... elements) {
        if (elements == null) {
            return array;
        }
        Class<?> type = array != null ? array.getClass() : elements.getClass();
        int n = elements.length;
        int oldLength = array == null ? 0 : array.length;
        T[] newArray = ArrayUtils.copyArrayGrowN(array, type, n);
        for (int i = 0; i < n; ++i) {
            newArray[oldLength + i] = elements[i];
        }
        return newArray;
    }

    public static byte[] append(byte[] array, byte ... elements) {
        if (elements == null) {
            return array;
        }
        Class<?> type = array != null ? array.getClass() : elements.getClass();
        int n = elements.length;
        int oldLength = array == null ? 0 : array.length;
        byte[] newArray = ArrayUtils.copyArrayGrowN(array, type, n);
        for (int i = 0; i < n; ++i) {
            newArray[oldLength + i] = elements[i];
        }
        return newArray;
    }

    public static <T> T[] remove(T[] array, int i) {
        int secondHalf;
        assert (array != null);
        assert (i >= 0 && i < array.length);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        int firstHalf = i;
        if (firstHalf > 0) {
            System.arraycopy(array, 0, newArray, 0, firstHalf);
        }
        if ((secondHalf = array.length - i - 1) > 0) {
            System.arraycopy(array, i + 1, newArray, i, secondHalf);
        }
        return (Object[])newArray;
    }

    public static void main(String[] args) {
        for (String s : ArrayUtils.foo("a", "b")) {
            System.out.println(s);
        }
        for (String s : ArrayUtils.bar("a", "b")) {
            System.out.println(s);
        }
        System.out.println("--");
        System.out.println(Arrays.toString(ArrayUtils.baz(0, "a", "b", "c", "d", "e")));
        System.out.println(Arrays.toString(ArrayUtils.baz(1, "a", "b", "c", "d", "e")));
        System.out.println(Arrays.toString(ArrayUtils.baz(2, "a", "b", "c", "d", "e")));
        System.out.println(Arrays.toString(ArrayUtils.baz(3, "a", "b", "c", "d", "e")));
        System.out.println(Arrays.toString(ArrayUtils.baz(4, "a", "b", "c", "d", "e")));
    }

    private static String[] foo(String ... values) {
        return ArrayUtils.append(values, "c", "d");
    }

    private static String[] bar(String ... values) {
        return ArrayUtils.append(values, new String[0]);
    }

    private static String[] baz(int r, String ... values) {
        return ArrayUtils.remove(values, r);
    }

    public static <T> T randomFromList(List<T> list) {
        assert (list.size() > 0);
        int i = (int)(Math.random() * (double)list.size());
        return list.get(i);
    }

    public static <T> T randomFromList(T[] array) {
        assert (array.length > 0);
        int i = (int)(Math.random() * (double)array.length);
        return array[i];
    }

    public static <T> boolean equalSet(T[] a, T[] b) {
        HashSet aSet = Sets.newHashSet((Object[])a);
        HashSet bSet = Sets.newHashSet((Object[])b);
        return aSet.equals(bSet);
    }
}

