/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.user.index;

import com.calpano.common.shared.xydrautils.XidIndex;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.index.iterator.AbstractTransformingIterator;
import org.xydra.store.session.SessionModel;

public abstract class StringIndex {
    private final XidIndex index;

    protected abstract XId getIndexObjectId();

    public StringIndex(SessionModel xm) {
        xm.loadObject(this.getIndexObjectId());
        XWritableObject xo = xm.getObject(this.getIndexObjectId());
        if (xo == null) {
            xo = xm.createObject(this.getIndexObjectId());
        }
        this.index = new XidIndex(xo);
    }

    public abstract XId toIndexKey(String var1);

    public boolean contains(String string) {
        return this.index.contains(this.toIndexKey(string));
    }

    public void deindex(String string) {
        this.index.deindex(this.toIndexKey(string));
    }

    public void index(String string, XId userId) {
        this.index.index(this.toIndexKey(string), userId);
    }

    public XId lookup(String string) {
        assert (string != null) : "lookup string is null";
        assert (!string.equals(""));
        return this.getValue(this.toIndexKey(string));
    }

    public XId getValue(XId keyId) {
        return this.index.lookupID(keyId);
    }

    public void batchUpdate(XId userId, String[] toIndex, String[] toDeIndex) {
        for (String stringAdressToDeindex : toIndex) {
            this.deindex(stringAdressToDeindex);
        }
        for (String stringAdressToIndex : toDeIndex) {
            this.index(stringAdressToIndex, userId);
        }
    }

    public void clear() {
        this.index.clear();
    }

    public Iterator<XId> keyIterator() {
        return this.index.keyIterator();
    }

    public Iterator<XId> valueIterator() {
        return new AbstractTransformingIterator<XId, XId>(this.keyIterator()){

            public XId transform(XId in) {
                return StringIndex.this.getValue(in);
            }
        };
    }
}

