/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.user.index;

import com.calpano.common.server.user.IServerUserService;
import com.calpano.common.server.user.index.StringIndex;
import com.calpano.common.shared.mail.EmailUtils;
import com.calpano.common.shared.user.base.SharedBaseUser;
import java.io.IOException;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.core.XX;
import org.xydra.core.index.impl.memory.IndexUtils;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.session.SessionModel;

@RequireConfInstance(value={IServerUserService.class})
public class EmailIndex
extends StringIndex {
    private static final Logger log = LoggerFactory.getLogger(EmailIndex.class);
    private static final XId INDEX_OBJECT_ID = XX.toId((String)"_index_email-user");

    public EmailIndex(SessionModel xm) {
        super(xm);
    }

    @Override
    public XId toIndexKey(String email) {
        assert (email != null);
        String normalized = EmailUtils.normalizeEmail((String)email);
        return IndexUtils.stringToXId((String)normalized);
    }

    public boolean emailAddressIsUsed(String email) {
        return this.contains(email);
    }

    public void deindexEmail(String email) {
        this.deindex(email);
    }

    public void indexEmail(String email, XId userId) {
        this.index(email, userId);
    }

    public void releaseEmail(String email) {
        this.deindex(email);
    }

    @Override
    public XId lookup(String email) {
        return super.lookup(email);
    }

    public boolean containsEmail(String email) {
        return this.contains(email);
    }

    @Override
    protected XId getIndexObjectId() {
        return INDEX_OBJECT_ID;
    }

    public static void rebuildEmailIndex(SessionModel userModel) throws IOException {
        log.info("Rebuilding email index");
        assert (userModel.hasObject(INDEX_OBJECT_ID)) : "indexObject must be loaded";
        EmailIndex emailIndex = new EmailIndex(userModel);
        emailIndex.clear();
        IServerUserService userService = (IServerUserService)Env.get().conf().getResolver(IServerUserService.class).resolve();
        Iterator<XId> it = userService.userIdIterator();
        long indexed = 0L;
        while (it.hasNext()) {
            XId xid = it.next();
            SharedBaseUser user = userService.getUserById(xid);
            String email = user.getEmail();
            emailIndex.indexEmail(email, xid);
            assert (emailIndex.containsEmail(email));
            ++indexed;
        }
        log.info("Indexed " + indexed + " user's email addresses");
        assert (EmailIndex.assertEmailIndexIsCorrect(userModel));
    }

    public static boolean assertEmailIndexIsCorrect(SessionModel userModel) throws IOException {
        assert (userModel.hasObject(INDEX_OBJECT_ID));
        EmailIndex emailIndex = new EmailIndex(userModel);
        IServerUserService userService = (IServerUserService)Env.get().conf().getResolver(IServerUserService.class).resolve();
        Iterator<XId> it = userService.userIdIterator();
        while (it.hasNext()) {
            XId xid = it.next();
            SharedBaseUser user = userService.getUserById(xid);
            boolean indexed = emailIndex.containsEmail(user.getEmail());
            if (indexed) continue;
            log.warn(user.getEmail() + " not indexed in email index <br/>");
            return false;
        }
        return true;
    }
}

