/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.tagrules;

import com.calpano.common.server.tagrules.TagRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TagRuleSet
implements Iterable<TagRule> {
    private static final Logger log = LoggerFactory.getLogger(TagRuleSet.class);
    private final Map<String, TagRule> tagMap = new HashMap<String, TagRule>();
    private boolean hullIsComputed = false;

    public void computeTransitiveHull() {
        if (this.hullIsComputed) {
            return;
        }
        boolean changes = true;
        while (changes) {
            changes = false;
            for (TagRule tag : this) {
                HashSet<String> toAdd = new HashSet<String>();
                for (String impliedStr : tag.getTransitiveImplied()) {
                    TagRule impliedTag = this.getTagRule(impliedStr);
                    for (String transitive : impliedTag.getTransitiveImplied()) {
                        if (tag.getTransitiveImplied().contains(transitive)) continue;
                        log.trace("inference: " + tag.getName() + "--" + impliedStr + "--" + transitive);
                        toAdd.add(transitive);
                        changes = true;
                    }
                }
                for (String s : toAdd) {
                    tag.getTransitiveImplied().add(s);
                }
            }
        }
        this.hullIsComputed = true;
    }

    public void add(TagRule tag) {
        this.hullIsComputed = false;
        this.tagMap.put(tag.getName(), tag);
        for (String s : tag.getDirectImplied()) {
            this.add(s);
        }
    }

    public void add(String tagWithoutRule) {
        TagRule tag = this.tagMap.get(tagWithoutRule);
        if (tag == null) {
            tag = new TagRule(tagWithoutRule, new String[0]);
            this.tagMap.put(tagWithoutRule, tag);
        }
    }

    @Override
    public Iterator<TagRule> iterator() {
        return this.tagMap.values().iterator();
    }

    public TagRule getTagRule(String tagName) {
        return this.tagMap.get(tagName);
    }

    public static void main(String[] args) {
        TagRuleSet tagSet = new TagRuleSet();
        tagSet.add(new TagRule("favrapp", "corporate"));
        tagSet.add(new TagRule("site", "corporate"));
        tagSet.add(new TagRule("consumer", "site"));
        tagSet.add(new TagRule("index", "consumer"));
        tagSet.add(new TagRule("frontpage", "consumer"));
        tagSet.add(new TagRule("landing", "consumer", "static"));
        tagSet.add(new TagRule("business", "site"));
        tagSet.computeTransitiveHull();
        tagSet.dump();
    }

    private void dump() {
        for (TagRule t : this) {
            System.out.println(t);
        }
    }

    public static Set<String> computeImplied(Set<String> tags, TagRuleSet tagRuleSet) {
        assert (tags != null);
        assert (tagRuleSet != null);
        tagRuleSet.computeTransitiveHull();
        HashSet<String> result = new HashSet<String>();
        for (String t : tags) {
            TagRule rule = tagRuleSet.getTagRule(t);
            if (rule != null) {
                result.addAll(rule.getTransitiveImplied());
                continue;
            }
            log.warn("No rule for '" + t + "'");
        }
        return result;
    }
}

