/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.memspace;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class MemspaceViaRuntime {
    private static final Logger log = LoggerFactory.getLogger(MemspaceViaRuntime.class);

    public static void writeMemoryAnalysis(Writer w) throws IOException {
        long free = 0L;
        long nextFree = 0L;
        do {
            free = nextFree;
            nextFree = Runtime.getRuntime().freeMemory();
            log.debug("free mem: " + free);
            Runtime.getRuntime().gc();
            Thread.yield();
        } while (nextFree > free);
        w.write("<h3>Memory Analysis</h3>");
        w.write("Total Memory (of current heap size): " + MemspaceViaRuntime.toByteSize(Runtime.getRuntime().totalMemory()) + "<br />\n");
        w.write("Free Memory: " + MemspaceViaRuntime.toByteSize(nextFree) + "<br />\n");
    }

    public static String toByteSize(long byteCount) {
        if (byteCount < 1024L) {
            return byteCount + " bytes";
        }
        if (byteCount < 0x100000L) {
            return (double)byteCount / 1024.0 + " KB";
        }
        if (byteCount < 0x40000000L) {
            return (double)byteCount / 1048576.0 + " MB";
        }
        return (double)byteCount / 1.073741824E9 + " GB";
    }

    public static void main(String[] args) throws IOException {
        System.out.println(MemspaceViaRuntime.toByteSize(42L));
        System.out.println(MemspaceViaRuntime.toByteSize(42123L));
        System.out.println(MemspaceViaRuntime.toByteSize(42123456L));
        System.out.println(MemspaceViaRuntime.toByteSize(1212345678L));
        HashSet set = new HashSet();
        for (int i = 0; i < 10000; ++i) {
            set.add(new HashSet());
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        MemspaceViaRuntime.writeMemoryAnalysis(w);
        ((Writer)w).close();
    }
}

