/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.memspace;

import com.calpano.common.server.hooks.IThreadInitialiser;
import com.calpano.common.server.memspace.MemspaceViaRuntime;
import de.xam.memspace.Memspace;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.SharedHtmlUtils;

public class MemspaceResource {
    private static final Logger log = LoggerFactory.getLogger(MemspaceResource.class);

    public static void restless(Restless restless, String prefix) {
        restless.addMethod("/memspace/", "GET", MemspaceResource.class, "index", true, new RestlessParameter[]{new RestlessParameter("fraction", "0.25")});
    }

    public void index(String fraction, HttpServletRequest req, HttpServletResponse res, Restless r) throws IOException {
        IThreadInitialiser ti = (IThreadInitialiser)Env.get().conf().tryToResolve(IThreadInitialiser.class);
        if (ti != null) {
            ti.run();
        }
        Double frac = Double.parseDouble(fraction);
        Writer w = HtmlUtils.startHtmlPage((HttpServletResponse)res, (String)("Memspace with ?fraction=" + fraction), (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
        MemspaceViaRuntime.writeMemoryAnalysis(w);
        w.write("<h2>Memspace with ?fraction=" + fraction + "</h2>");
        Memspace.writeStats((Object)r.getServletContext(), (double)frac, (String[])new String[]{"org.xydra.store.StatsPersistence"}, (Writer)w);
        HtmlUtils.endHtmlPage((Writer)w);
    }
}

