/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.local;

import com.calpano.common.server.util.CssTemplateCompiler;
import de.xam.resourceloader.p13n.P13nPropertyFileWriter;
import java.io.File;
import java.io.IOException;
import org.apache.velocity.exception.MethodInvocationException;
import org.xydra.conf.ConfigException;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.gwttools.GwtBuildHelper;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LocalBuildHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalBuildHelper.class);
    private static String mavenId;
    private static boolean configHasBeenRead;
    public static CssTemplateCompiler CSS_TEMPLATE_COMPILER;
    public static P13nPropertyFileWriter PROP_WRITER;
    private static String projectRootDirAbsolute;

    public static void copyStaticResources() {
    }

    public static boolean isGwtUsed(IConfig conf) {
        try {
            return conf.getBoolean("gwtUsed");
        }
        catch (ConfigException e) {
            return true;
        }
    }

    @RequireConf(value={"mavenProjectRootDir", "gwtModules", "appArtifactId", "appMavenVersion"})
    public static void copyGwt() {
        LocalBuildHelper.assertConfigIsProcessed(false, false);
        LocalBuildHelper.doGwt();
    }

    private static void doGwt() {
        String[] modules = (String[])Env.get().conf().tryToGetAs("gwtModules", String[].class);
        if (modules == null) {
            log.warn("No GWT modules configured.");
        }
        if (LocalBuildHelper.isGwtUsed(Env.get().conf())) {
            GwtBuildHelper.copyAllGwtModulesFoundInTarget((String)LocalBuildHelper.getTargetWebAppDir(), (String)LocalBuildHelper.getSrcMainWebapp());
        }
    }

    public static String getSrcMainWebapp() {
        assert (configHasBeenRead);
        return projectRootDirAbsolute + "/src/main/webapp";
    }

    public static String getTargetWebAppDir() {
        assert (configHasBeenRead);
        return projectRootDirAbsolute + "/target/" + mavenId;
    }

    public static void compileStaticPages() {
    }

    public static void compileP13nBundlesForGwt() {
        LocalBuildHelper.assertConfigIsProcessed(false, true);
        LocalBuildHelper.doP13n();
    }

    private static void doP13n() {
        if (PROP_WRITER != null) {
            PROP_WRITER.run();
        }
    }

    private static void assertConfigIsProcessed(boolean css, boolean p13n) {
        boolean gwtI18nBundleWriter;
        boolean cssTemplateCompiler;
        if (configHasBeenRead) {
            return;
        }
        IConfig conf = Env.get().conf();
        String appArtifactId = conf.getString("appArtifactId");
        String version = conf.getString("appMavenVersion");
        mavenId = appArtifactId + "-" + version;
        String projectRootDir = conf.getString("mavenProjectRootDir");
        if (projectRootDir == null) {
            log.warn("Assume you call this WITHIN the project you want to build");
            projectRootDirAbsolute = ".";
        } else {
            projectRootDirAbsolute = projectRootDir;
        }
        if (css && (cssTemplateCompiler = conf.getBoolean("cssTemplateCompiler"))) {
            CSS_TEMPLATE_COMPILER = new CssTemplateCompiler(conf.getString("cssTemplateDir"), conf.getString("cssTemplateName"), conf.getString("cssTemplateExt"), conf.getString("cssTargetDirPath"), "css");
        }
        if (p13n && (gwtI18nBundleWriter = conf.getBoolean("gwtI18nBundleWriter"))) {
            PROP_WRITER = new P13nPropertyFileWriter(conf.getStringSet("x-supportedLanguages").toArray(new String[0]), conf.getStringSet("pageMessagePackage").toArray(new String[0]), conf.getStringSet("p13nMessagePrefixedUsedOnlyOnServer").toArray(new String[0]), new File(conf.getString("p13nBundleForGwtTargetDir")), "\n");
        }
        configHasBeenRead = true;
    }

    public static void compileCss() {
        LocalBuildHelper.assertConfigIsProcessed(true, false);
        LocalBuildHelper.doCss();
    }

    private static void doCss() {
        if (CSS_TEMPLATE_COMPILER != null) {
            CSS_TEMPLATE_COMPILER.run();
        }
    }

    public static void buildAll() {
        LocalBuildHelper.assertConfigIsProcessed(true, true);
        LocalBuildHelper.doCss();
        LocalBuildHelper.doGwt();
        LocalBuildHelper.doP13n();
    }

    public static void main(String[] args) throws MethodInvocationException, IOException {
        LocalBuildHelper.buildAll();
    }

    static {
        configHasBeenRead = false;
    }
}

