/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server;

import com.calpano.common.server.AppBase;
import com.calpano.common.server.services.crashreport.SimpleRestlessExceptionHandler;
import de.xam.googleanalytics.logsink.GALogListener;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.log.api.ILogListener;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.XydraRuntime;

@RequireConf(value={"inProduction", "log-serverSideLogging_GoogleAnalytics_DomainName", "log-serverSideLogging_GoogleAnalytics_UACode"})
public class DynamicContentBase {
    private static final Logger log = LoggerFactory.getLogger(DynamicContentBase.class);

    public static void redirectLoggingToGoogleAnalytics() {
        IConfig conf = Env.get().conf();
        if (conf.getBoolean("log-serverSideLogging")) {
            conf.assertDefined("log-serverSideLogging_GoogleAnalytics_UACode");
            conf.assertDefined("log-serverSideLogging_GoogleAnalytics_DomainName");
            if (conf.getBoolean("inProduction")) {
                LoggerFactory.addLogListener((ILogListener)new GALogListener(conf.getString("log-serverSideLogging_GoogleAnalytics_UACode"), conf.getString("log-serverSideLogging_GoogleAnalytics_DomainName")));
            }
        }
    }

    public static void turnRestlessErrorsToServletErrors(Restless restless) {
        IConfig conf = Env.get().conf();
        restless.addExceptionHandler((RestlessExceptionHandler)new SimpleRestlessExceptionHandler(!conf.getBoolean("runLocal"), (int)conf.getLong("error_redirectMs"), restless));
    }

    public static void forwardWebRequestsToXydra(Restless restless) {
        restless.addRequestListener(new Restless.IRequestListener(){

            public void onRequestFinished(IRestlessContext restlessContext) {
                XydraRuntime.finishRequest();
            }

            public void onRequestStarted(IRestlessContext restlessContext) {
                XydraRuntime.startRequest();
            }
        });
    }

    public static void configureFromWebXml(IConfig config, ServletConfig servletConfig) {
        log.info("Configure from web.xml");
        Enumeration en = servletConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            config.set(name, (Object)value);
        }
    }

    public static void configure(Restless restless) {
        AppBase.configure();
        XyAssert.enable();
        IConfig config = Env.get().conf();
        DynamicContentBase.configureDefaults(config);
        DynamicContentBase.configureFromWebXml(config, restless.getServletConfig());
    }

    private static void configureDefaults(IConfig config) {
        config.setDefault("staticPathPrefixes", (Object)"/s/", true);
    }
}

