/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server;

import com.calpano.common.server.DynamicContentBase;
import com.calpano.common.server.rest.CronResource;
import com.calpano.common.server.rest.UnderscoreAhResource;
import org.xydra.common.NanoClock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;

public class DynamicContentApp {
    private static final Logger log = LoggerFactory.getLogger(DynamicContentApp.class);

    public static void restless(Restless restless, String prefix) {
        NanoClock clock = new NanoClock().start();
        try {
            DynamicContentBase.configure(restless);
            DynamicContentBase.turnRestlessErrorsToServletErrors(restless);
            clock.stopAndStart("turnRestlessErrorsToServletErrors");
            DynamicContentBase.redirectLoggingToGoogleAnalytics();
            clock.stopAndStart("redirectLoggingToGoogleAnalytics");
            DynamicContentBase.forwardWebRequestsToXydra(restless);
            clock.stopAndStart("forwardWebRequestsToXydra");
            DynamicContentApp.restless_setupServices(restless, clock);
            log.info("FavrApp.restless: " + clock.getStats());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error setting up FavrApp", (Throwable)e);
            throw new RuntimeException("Error setting up FavrApp", e);
        }
    }

    private static void restless_setupServices(Restless restless, NanoClock clock) {
        CronResource.restless(restless, "");
        clock.stopAndStart("CronResource");
        UnderscoreAhResource.restless(restless, "");
    }
}

