/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.appground.webbase.client.impl;

import com.calpano.appground.webbase.client.IBrowserApp;
import com.calpano.appground.webbase.client.IBrowserAppConf;
import com.calpano.appground.webbase.client.conf.BrowserAppConf;
import com.calpano.common.client.AppState;
import com.calpano.common.client.ClientApp;
import com.calpano.common.client.util.ConsoleHelper;
import com.calpano.common.client.util.IStringTransformer;
import com.calpano.common.client.view.forms.StaticFormManager;
import com.calpano.common.client.view.forms.utils.EventUtil;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import org.xydra.env.Env;
import org.xydra.env.IEnvironment;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class WebBaseEntryPoint
implements EntryPoint {
    private static final Logger log = LoggerFactory.getLogger(WebBaseEntryPoint.class);
    private IEnvironment env;

    public void onModuleLoad() {
        log.info("WebBase: Loading module");
        ConsoleHelper.timeStart((String)"boot");
        log.info("WebBase: Creating client env");
        this.env = Env.get();
        log.info("Determine debug mode");
        String debugStr = Window.Location.getParameter((String)"debug");
        if (debugStr != null) {
            try {
                boolean debugMode = debugStr.equalsIgnoreCase("debug");
                this.env.conf().setBoolean("clientDebugMode", debugMode);
                if (debugMode) {
                    EventUtil.startEventListening();
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not understand debugmode '" + debugStr + "'");
            }
        }
        ClientApp clientApp = new ClientApp(this.env);
        Window.addWindowClosingHandler((Window.ClosingHandler)clientApp);
        Window.addCloseHandler((CloseHandler)clientApp);
        StaticFormManager.registerStringTransformer((IStringTransformer)new IStringTransformer(){

            public String transform(String raw) {
                return raw;
            }
        });
        AppState.addListener((AppState.AppStateListener)clientApp);
        clientApp.onAppStateChange();
        log.debug("WebBase: Get client app");
        IBrowserAppConf conf = (IBrowserAppConf)GWT.create(BrowserAppConf.class);
        IBrowserApp browserApp = conf.createApp();
        log.debug("WebBase: Client app created.");
        browserApp.onAppLoad();
        log.debug("Browser app initialised.");
        log.debug("WebBase: Get client widget");
        IsWidget mainWidget = browserApp.createMainWidget();
        log.debug("WebBase: Get root panel");
        RootPanel p = RootPanel.get();
        log.debug("WebBase: Adding");
        p.add(mainWidget);
        log.info("WebBase: And we're live");
    }
}

