/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import de.xam.files.FilenameUtils;
import de.xam.p13n.shared.P13nSearchUtils;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.PersonalisedMessageBundle;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.resourceloader.ResourceLoaderTool;
import de.xam.resourceloader.p13n.PersonalisedMessageBundleIO;
import de.xam.texthtml.markdown.Markdown;
import de.xam.texthtml.text.EncTool;
import de.xam.texthtml.text.HumanReadableText;
import de.xam.texthtml.text.TextRenderer;
import de.xam.texthtml.text.TextTool;
import de.xam.velocity.CustomUberSpectImpl;
import de.xam.velocity.DataFromTemplate;
import de.xam.velocity.FlexibleResourceLoader;
import de.xam.velocity.IVelocitySupport;
import de.xam.velocity.IteratorTool;
import de.xam.velocity.ReflectiveContextEntry;
import de.xam.velocity.ReflectiveHttpRequestContextEntry;
import de.xam.velocity.Velocity2XydraLogger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogChute;
import org.xydra.common.NanoClock;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.env.Env;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.iterator.Iterators_NoGwt;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.spi.ILoggerFactorySPI;

public class VelocityManager {
    private static Logger log = LoggerFactory.getLogger(VelocityManager.class);
    public static final org.apache.log4j.Logger log4j = org.apache.log4j.Logger.getLogger((String)VelocityManager.class.getName());
    private PersonalisedMessageBundle personalisedMessageBundle;
    private ResourceLoaderTool.Resolver resolver;
    private final VelocityEngine ve;

    public static void add_call(HttpServletRequest req, Map<String, Object> map) {
        ReflectiveHttpRequestContextEntry reflectiveHttpRequestContextEntry = new ReflectiveHttpRequestContextEntry(req);
        map.put("call", reflectiveHttpRequestContextEntry);
    }

    public static Map<String, Object> getDebugData(IVelocitySupport velocitySupport) {
        HashMap<String, Object> debugData = new HashMap<String, Object>();
        if (velocitySupport.getDebugDataForContext() != null) {
            debugData.put("data", velocitySupport.getDebugDataForContext());
        }
        debugData.put("p13n", velocitySupport.getPersonalisation());
        debugData.put("p13n-locale", velocitySupport.getPersonalisation().getLocale());
        debugData.put("p13n-locale-country", velocitySupport.getPersonalisation().getLocale().getCountry());
        debugData.put("p13n-locale-lang", velocitySupport.getPersonalisation().getLocale().getLanguage());
        debugData.put("p13n-locale-variant", velocitySupport.getPersonalisation().getLocale().getVariant());
        return debugData;
    }

    public static Object getNull() {
        return null;
    }

    public static String getTemplateName(Class<?> clazz) {
        if (clazz == null) {
            throw new RuntimeException("Given class was null");
        }
        String className = clazz.getName();
        String searchName = className.toLowerCase();
        int lastSlash = className.lastIndexOf(47);
        if (lastSlash > 0) {
            searchName = searchName.substring(0, lastSlash);
        }
        if (searchName.endsWith("velocity")) {
            searchName = searchName.substring(0, searchName.length() - "velocity".length());
        }
        if (searchName.endsWith("resource")) {
            searchName = searchName.substring(0, searchName.length() - "resource".length());
        }
        return searchName;
    }

    public static PersonalisedMessageBundle loadMessagesMap(Personalisation p13n, String[] packageNames) {
        assert (p13n != null) : "p13n null";
        PersonalisedMessageBundle personalisedMessageBundle = PersonalisedMessageBundleIO.instance((Personalisation)p13n, (String[])packageNames);
        return personalisedMessageBundle;
    }

    public static boolean notNull(Object o) {
        return o != null;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static String resolveTemplatePath(Class<?> clazz, Personalisation p13n) {
        return VelocityManager.resolveTemplatePath(VelocityManager.getTemplateName(clazz), p13n);
    }

    public static String resolveTemplatePath(String searchName, Personalisation p13n) {
        String resourceNamePrefix;
        String packageName;
        if (!searchName.contains(".")) {
            throw new IllegalArgumentException("Resources should be organized in packages to avoid conflicts. Use at least one level of packages.");
        }
        int lastDot = searchName.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = searchName.substring(0, lastDot);
            resourceNamePrefix = searchName.substring(lastDot + 1);
        } else {
            packageName = "";
            resourceNamePrefix = searchName;
        }
        String result = VelocityManager.resolveTemplatePath(packageName, resourceNamePrefix, "vm", p13n);
        if (result == null) {
            throw new RuntimeException("No template found in package '" + packageName + "' (might be too generic) named '" + resourceNamePrefix + ".vm' with p13n=" + p13n);
        }
        return result;
    }

    public static String resolveTemplatePath(String packageName, String resourceNamePrefix, String resourceNameExtension, Personalisation p13n) {
        if (log.isTraceEnabled()) {
            log.trace("Resolving '" + resourceNamePrefix + "' in package '" + packageName + "'");
        }
        for (String templatePath : P13nSearchUtils.getFromGeneralToSpecific((String)packageName, (Personalisation)p13n, (String)resourceNamePrefix, (String)resourceNameExtension)) {
            if (log.isTraceEnabled()) {
                log.trace("Trying to resolve '" + resourceNamePrefix + "' as '" + templatePath + "'");
            }
            if (!ResourceLoaderTool.resourceExistsOnClasspath((String)templatePath)) continue;
            log.debug("Resolving '" + resourceNamePrefix + "' as '" + templatePath + "'");
            return templatePath;
        }
        return null;
    }

    public VelocityManager() {
        this(null);
    }

    @RequireConfInstance(value={LogChute.class, ILoggerFactorySPI.class})
    public VelocityManager(File rootPath) {
        boolean loadResourceFromFilesystem;
        NanoClock c = new NanoClock();
        c.start();
        this.ve = new VelocityEngine();
        Vector<String> resourceLoaderNames = new Vector<String>();
        resourceLoaderNames.add("flex");
        IConfig conf = Env.get().conf();
        boolean bl = loadResourceFromFilesystem = rootPath != null && rootPath.exists() && rootPath.isDirectory();
        if (loadResourceFromFilesystem) {
            assert (rootPath != null);
            this.ve.setProperty("flex.resource.loader.path", (Object)rootPath.getAbsolutePath());
            String search = (String)conf.tryToGetAs("template-resourceLoaderSearch", String.class);
            String replace = (String)conf.tryToGetAs("template-resourceLoaderReplace", String.class);
            if (search != null && replace != null) {
                this.ve.setProperty("flex.resource.loader.search", (Object)search);
                this.ve.setProperty("flex.resource.loader.replace", (Object)replace);
            }
        }
        this.ve.setProperty("flex.resource.loader.continueWithMissingResources", conf.tryToGetAs("template-resourceLoaderContinueWithMissingResources", Boolean.TYPE));
        this.ve.setProperty("flex.resource.loader.class", (Object)FlexibleResourceLoader.class.getCanonicalName());
        if (loadResourceFromFilesystem) {
            log.info("Loading resources from file system and class path");
            this.resolver = new ResourceLoaderTool.AnyResolver(rootPath, new File[0]);
        } else {
            log.info("Loading resources from class path only = default production setting");
            this.resolver = new ResourceLoaderTool.ClasspathResolver();
        }
        this.ve.setProperty("resource.loader", resourceLoaderNames);
        this.ve.setProperty("parser.pool.size", (Object)"4");
        this.ve.setProperty("directive.set.null.allowed", (Object)"true");
        this.ve.setProperty("input.encoding", (Object)"UTF-8");
        this.ve.setProperty("output.encoding", (Object)"UTF-8");
        this.ve.setProperty("runtime.references.strict", (Object)"true");
        this.ve.setProperty("runtime.introspector.uberspect", (Object)CustomUberSpectImpl.class.getCanonicalName());
        ILoggerFactorySPI loggerFactory = (ILoggerFactorySPI)Env.get().conf().resolve(ILoggerFactorySPI.class);
        Velocity2XydraLogger logChute = new Velocity2XydraLogger(loggerFactory);
        this.ve.setProperty("runtime.log.logsystem", (Object)logChute);
        this.ve.setProperty("resource.manager.defaultcache.size", (Object)200);
        try {
            this.ve.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        c.stop("init velocity");
        log.info("DONE init velocity, took: " + c.getDurationSinceStart() + " ms");
    }

    public PersonalisedMessageBundle getPersonalisedMessageBundle(String[] packageNames, Personalisation p13n) {
        if (this.personalisedMessageBundle == null) {
            this.personalisedMessageBundle = this.loadMessagesMap(p13n, this.resolver, packageNames);
        }
        return this.personalisedMessageBundle;
    }

    public String getUtcDateTime() {
        return HumanReadableText.fullDateTimeIso((long)TimeProvider.getCurrentTimeInMillis());
    }

    public PersonalisedMessageBundle loadMessagesMap(Personalisation p13n, ResourceLoaderTool.Resolver resolver, String[] packageNames) {
        assert (p13n != null) : "p13n null";
        PersonalisedMessageBundle personalisedMessageBundle = PersonalisedMessageBundleIO.instance((Personalisation)p13n, (ResourceLoaderTool.Resolver)resolver, (String[])packageNames);
        return personalisedMessageBundle;
    }

    public Template loadTemplateFromFile(File rootDir, File srcFile) {
        try {
            String relPath = FilenameUtils.getRelativePath((File)rootDir, (File)srcFile);
            Template template = this.ve.getTemplate(relPath, "UTF-8");
            return template;
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Could not find file '" + srcFile.getAbsolutePath() + "'", e);
        }
        catch (ParseErrorException e) {
            throw new RuntimeException("Could not parse file '" + srcFile.getAbsolutePath() + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on file '" + srcFile.getAbsolutePath() + "'", e);
        }
    }

    public Template resolveTemplate(Class<?> clazz, Personalisation p13n) {
        String templatePath = VelocityManager.resolveTemplatePath(clazz, p13n);
        Template template = this.resolveTemplate(templatePath);
        return template;
    }

    public Template resolveTemplate(String templatePath) {
        assert (templatePath != null) : "Given templatepath was null";
        if (log.isTraceEnabled()) {
            log.trace("Resolving template '" + templatePath + "'");
        }
        try {
            Template template = this.ve.getTemplate(templatePath, "UTF-8");
            return template;
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Could not find '" + templatePath + "'", e);
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Could not find '" + templatePath + "'", e);
        }
        catch (ParseErrorException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> toMap(HttpServletRequest req, IVelocitySupport velocitySupport) {
        Map<String, Object> map = this.toMap(velocitySupport);
        VelocityManager.add_call(req, map);
        return map;
    }

    public Map<String, Object> toMap(IVelocitySupport velocitySupport) {
        Personalisation p13n;
        String[] packageNames = velocitySupport.getMessagePackages();
        PersonalisedMessageBundle pmb = this.getPersonalisedMessageBundle(packageNames, p13n = velocitySupport.getPersonalisation());
        if (pmb == null) {
            log.warn("could not load a PMB in " + packageNames);
        }
        velocitySupport.setPersonalisedMessageBundle(pmb);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", velocitySupport.getDataForContext());
        map.put("msg", pmb);
        map.put("templ", new DataFromTemplate());
        map.put("text", new TextRenderer());
        map.put("humanReadableText", new HumanReadableText());
        map.put("Iterators", Iterators.class);
        map.put("Iterators_NoGwt", Iterators_NoGwt.class);
        map.put("TextTool", TextTool.class);
        map.put("it", new IteratorTool());
        map.put("Integer", Integer.class);
        map.put("null", null);
        map.put("p13n", p13n);
        map.put("runlocal", !Env.get().conf().getBoolean("template-inProduction"));
        map.put("velocity", this);
        map.put("enc", EncTool.getInstance());
        map.put("clock", new NanoClock().start());
        boolean debugMode = Env.get().conf().getBoolean("template-debugModeServer");
        map.put("debugmode", debugMode);
        if (debugMode) {
            map.put("conf", Env.get().conf());
            map.put("debug", VelocityManager.getDebugData(velocitySupport));
            ReflectiveContextEntry reflectiveContextEntry = new ReflectiveContextEntry(velocitySupport);
            map.put("dev", reflectiveContextEntry);
        }
        return map;
    }

    public Map<String, Object> writeResponse(IVelocitySupport velocitySupport, Template template, Writer writer) {
        Map<String, Object> dataMap = this.toMap(velocitySupport);
        this.writeTo(template, dataMap, writer, velocitySupport.interpretMarkdown());
        return dataMap;
    }

    public void writeTo(Template template, Map<String, Object> dataMap, HttpServletResponse res, boolean interpretMarkdown) {
        try {
            ServletOutputStream out = res.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
            res.setCharacterEncoding("utf-8");
            this.writeTo(template, dataMap, writer, interpretMarkdown);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(Template template, Map<String, Object> dataMap, Writer writer, boolean interpretMarkdown) {
        assert (template != null);
        if (log.isTraceEnabled()) {
            log.trace("START use template '" + template.getName() + "' and write ");
        }
        NanoClock c = new NanoClock().start();
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        c.stopAndStart("copy-data-map");
        try {
            if (interpretMarkdown) {
                StringWriter sw = new StringWriter();
                template.merge((Context)context, (Writer)sw);
                sw.close();
                String in = sw.getBuffer().toString();
                String markdowned = Markdown.interpretMarkdown((String)in);
                writer.write(markdowned);
            } else {
                template.merge((Context)context, writer);
            }
            c.stopAndStart("merged");
            writer.flush();
            c.stopAndStart("flushed");
        }
        catch (IOException | MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            log.warn("While processing " + template.getName(), e);
            VelocityManager.dumpContext("Context ", context);
            VelocityManager.dumpMap("Context.data ", dataMap);
            throw new RuntimeException("While processing " + template.getName(), e);
        }
        c.stop("render-raw " + template.getName());
        log.debug("Render stats for template '" + template.getName() + "': " + c.getStats());
        log.debug("DONE processing template '" + template.getName() + "' and writing");
    }

    private static void dumpMap(String label, Map<String, Object> dataMap) {
        ArrayList<String> dataKeys = new ArrayList<String>();
        dataKeys.addAll(dataMap.keySet());
        Collections.sort(dataKeys);
        for (String key : dataKeys) {
            Object value = dataMap.get(key);
            VelocityManager.dumpKeyValue(label, key, value);
        }
    }

    private static void dumpContext(String label, VelocityContext context) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object o : context.getKeys()) {
            keys.add((String)o);
        }
        Collections.sort(keys);
        for (String key : keys) {
            Object value = context.get(key);
            VelocityManager.dumpKeyValue(label, key, value);
        }
    }

    private static void dumpKeyValue(String label, String key, Object value) {
        log.info(label + "'" + key + "'= (" + (value == null ? "NULL" : value.getClass().getName()) + ") '" + value + "'");
    }
}

