/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import de.xam.resourceloader.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.xydra.annotations.LicenseApache;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

@LicenseApache(project="Apache Velocity")
public class FlexibleResourceLoader
extends org.apache.velocity.runtime.resource.loader.ResourceLoader {
    private static final Logger xydraLog = LoggerFactory.getLogger(FlexibleResourceLoader.class);
    private ResourceLoader resourceLoader;
    private boolean continueWithMissingResources = false;

    public void init(ExtendedProperties configuration) {
        boolean continueWithMissingResources;
        assert (configuration != null);
        this.resourceLoader = new ResourceLoader();
        this.resourceLoader.addBaseDirs((Collection)configuration.getVector("path"));
        String search = configuration.getString("search");
        String replace = configuration.getString("replace");
        if (search != null && replace != null) {
            this.resourceLoader.setAutoPathSearchAndReplace(search.trim(), replace.trim());
        }
        if (continueWithMissingResources = configuration.getBoolean("continueWithMissingResources")) {
            this.continueWithMissingResources = true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"FlexibleResourceLoader : initialization complete.");
        }
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((String)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        try {
            InputStream in = this.resourceLoader.getResourceAsStream(name);
            xydraLog.trace("Loaded resource '" + name + "'");
            return in;
        }
        catch (de.xam.resourceloader.ResourceNotFoundException e) {
            if (this.continueWithMissingResources) {
                this.log.warn((Object)("Resource '" + name + "' not found. Returning syntehtic resource wiht warning message."), (Throwable)e);
                String syntheticResource = "!!! The resource '" + name + "' is missing !!!";
                ByteArrayInputStream stream = new ByteArrayInputStream(syntheticResource.getBytes(StandardCharsets.UTF_8));
                return stream;
            }
            throw new ResourceNotFoundException("FlexibleResourceLoader Error: cannot find resource", (Throwable)e);
        }
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

