/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.xydra.annotations.LicenseApache;

@LicenseApache(copyright="Copyright 2003-2004 The Apache Software Foundation.")
public class CustomUberSpectImpl
extends UberspectImpl {
    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        Class<?> clazz = obj.getClass();
        boolean isArray = clazz.isArray();
        boolean isLength = identifier.equals("length");
        if (isArray && isLength) {
            return new ArrayLengthGetter();
        }
        VelPropertyGet getter = super.getPropertyGet(obj, identifier, i);
        try {
            getter.getMethodName();
            return getter;
        }
        catch (NullPointerException notFound) {
            try {
                Field field = obj.getClass().getField(identifier);
                if (field != null) {
                    return new PublicFieldGetter(field);
                }
            }
            catch (NoSuchFieldException e) {
                this.log.error((Object)("Could not find field '" + identifier + "' in class '" + clazz.getCanonicalName() + "'"));
            }
            return null;
        }
    }

    protected class ArrayLengthGetter
    implements VelPropertyGet {
        public Object invoke(Object o) throws Exception {
            return new Integer(Array.getLength(o));
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return "array length getter";
        }
    }

    protected class PublicFieldGetter
    implements VelPropertyGet {
        private Field field = null;

        public PublicFieldGetter(Field field) {
            this.field = field;
        }

        public Object invoke(Object o) throws Exception {
            return this.field.get(o);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return "public field getter";
        }
    }
}

