/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.util.CollectionFilter;
import org.fest.util.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    public static <T> List<T> list(T ... elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    public static <T> List<T> list(T element) {
        if (element == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    public static <T> List<T> list(T first, T second) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(first);
        list.add(second);
        return list;
    }

    public static <T> Set<T> set(T ... elements) {
        if (elements == null) {
            return null;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <T> Set<T> set(T element) {
        if (element == null) {
            return null;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.add(element);
        return set;
    }

    public static <T> Set<T> set(T first, T second) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.add(first);
        set.add(second);
        return set;
    }

    public static <T> Collection<T> duplicatesFrom(Collection<T> c) {
        HashSet<T> duplicates = new HashSet<T>();
        if (Collections.isEmpty(c)) {
            return duplicates;
        }
        HashSet<T> noDuplicates = new HashSet<T>();
        for (T e : c) {
            if (noDuplicates.contains(e)) {
                duplicates.add(e);
                continue;
            }
            noDuplicates.add(e);
        }
        return duplicates;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static int sizeOf(Iterable<?> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("iterable parameter must not be null");
        }
        int size = 0;
        for (Object object : iterable) {
            ++size;
        }
        return size;
    }

    public static <T> List<T> filter(Collection<?> target, CollectionFilter<T> filter) {
        return filter.filter(target);
    }

    public static String format(Collection<?> c) {
        if (c == null) {
            return null;
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        while (true) {
            Object e;
            b.append((e = i.next()) == c ? "(this Collection)" : ToString.toStringOf(e));
            if (!i.hasNext()) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
    }

    public static <T> Iterable<T> nonNullElements(Iterable<T> c) {
        if (c == null) {
            return null;
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : c) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return java.util.Collections.unmodifiableCollection(nonNullElements);
    }

    public static <T> List<T> nonNullElements(List<T> l) {
        Collection nonNullElements = (Collection)Collections.nonNullElements(l);
        if (nonNullElements == null) {
            return null;
        }
        return java.util.Collections.unmodifiableList(new ArrayList(nonNullElements));
    }

    public static boolean hasOnlyNullElements(Iterable<?> iterable) {
        if (iterable == null) {
            throw new NullPointerException("The iterable to check should not be null");
        }
        if (Collections.isEmpty(iterable)) {
            return false;
        }
        for (Object element : iterable) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> list(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T e : iterable) {
            list.add(e);
        }
        return list;
    }

    private Collections() {
    }
}

