/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import java.util.HashSet;
import org.fest.util.Collections;
import org.fest.util.ComparisonStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComparisonStrategy
implements ComparisonStrategy {
    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        HashSet duplicates = new HashSet();
        if (Collections.isEmpty(iterable)) {
            return duplicates;
        }
        HashSet noDuplicates = new HashSet();
        for (Object element : iterable) {
            if (this.iterableContains(noDuplicates, element)) {
                duplicates.add(element);
                continue;
            }
            noDuplicates.add(element);
        }
        return duplicates;
    }

    @Override
    public boolean arrayContains(Object array, Object value) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element = Array.get(array, i);
            if (!this.areEqual(element, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return false;
        }
        return !this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isLessThanOrEqualTo(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return true;
        }
        return this.isLessThan(actual, other);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return true;
        }
        return this.isGreaterThan(actual, other);
    }
}

