/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.util;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CFactory;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.impl.mem.MemoryFactory;
import de.xam.cmodel.value.impl.ByteBasedIdImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.xydra.base.Base;
import org.xydra.base.IHasXId;
import org.xydra.base.XId;
import org.xydra.base.id.MemoryStringIDProvider;
import org.xydra.base.id.SimpleUTF8;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.index.ITripleIndex;
import org.xydra.index.impl.UniformTripleIndex;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.EqualsConstraint;
import org.xydra.index.query.ITriple;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CUtils {
    private static final Logger log = LoggerFactory.getLogger(CUtils.class);

    public static void addBuiltInVocabulary(CFactory factory, CFactSet factSet) {
        XId hasInverseRelation = factory.createId();
        factSet.addSymbol(factory.createSymbol(hasInverseRelation, factory.contentFactory().createValueContent((XValue)XV.toValue((String)"hasInverse")), true));
    }

    public static void addContextModelTriple(CFactory factory, CFactSet factSet, IHasXId s, IHasXId p, IHasXId o) {
        CUtils.addTriple(factory, factSet.getWritableContextModel(), s, p, o);
    }

    public static void addFile(CFactory factory, CFactSet factSet, File f) {
        byte[] fileContentBytes;
        CSymbol fileName = CUtils.createAndAddReferenceSymbol(factory, factSet, f.getAbsolutePath());
        try {
            fileContentBytes = FileUtils.readFileToByteArray((File)f);
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
        XBinaryValue fileContentValue = XV.toValue((byte[])fileContentBytes);
        CSymbol fileContent = CUtils.createAndAddSymbol(factory, factSet, (XValue)fileContentValue);
        XId id_file = factory.createId();
        CSymbol hasType = CUtils.createAndAddReferenceSymbol(factory, factSet, "hasType");
        CSymbol typeFile = CUtils.createAndAddReferenceSymbol(factory, factSet, "File");
        CSymbol hasName = CUtils.createAndAddReferenceSymbol(factory, factSet, "hasName");
        CSymbol hasContent = CUtils.createAndAddReferenceSymbol(factory, factSet, "hasContent");
        CUtils.createAndAddTriple(factory, factSet, (IHasXId)id_file, hasType, typeFile);
        CUtils.createAndAddTriple(factory, factSet, (IHasXId)id_file, hasName, fileName);
        CUtils.createAndAddTriple(factory, factSet, (IHasXId)id_file, hasContent, fileContent);
    }

    public static void addTriple(CFactory factory, CFactSet factSet, IHasXId s, IHasXId p, IHasXId o) {
        CTriple triple = CUtils.createTriple(factory, s, p, o);
        factSet.addTriple(triple);
    }

    public static byte[] combine(XId a, XId b) {
        assert (a != null);
        assert (b != null);
        byte[] combined = CUtils.combineToBytes(a, b);
        return combined;
    }

    public static XId combine(XId a, XId b, XId c) {
        assert (a != null);
        assert (b != null);
        assert (c != null);
        byte[] combinedIdBytes = CUtils.combineToBytes(a, b, c);
        return CUtils.validIdWhichIsRandomIfItMust(combinedIdBytes);
    }

    public static byte[] combineToBytes(XId a, XId b) {
        byte[] a_ = a.toBytes();
        byte[] b_ = b.toBytes();
        byte[] x_ = new byte[a_.length + b_.length];
        System.arraycopy(a_, 0, x_, 0, a_.length);
        System.arraycopy(b_, 0, x_, a_.length, b_.length);
        return x_;
    }

    public static byte[] combineToBytes(XId a, XId b, XId c) {
        byte[] a_ = a.toBytes();
        byte[] b_ = b.toBytes();
        byte[] c_ = c.toBytes();
        byte[] x_ = new byte[a_.length + b_.length + c_.length];
        System.arraycopy(a_, 0, x_, 0, a_.length);
        System.arraycopy(b_, 0, x_, a_.length, b_.length);
        System.arraycopy(c_, 0, x_, a_.length + b_.length, c_.length);
        return x_;
    }

    public static CSymbol createAndAddReferenceSymbol(CFactory factory, CFactSet factSet, String stringContent) {
        CSymbol symbol = factory.createSymbol(Base.createUniqueId(), factory.contentFactory().createValueContent((XValue)XV.toValue((String)stringContent)), true);
        factSet.addSymbol(symbol);
        return symbol;
    }

    public static CSymbol createAndAddStringSymbolWithId(MemoryFactory factory, CFactSet factSet, XId id, String contentString) {
        CBrowserRenderableContent content = factory.contentFactory().createValueContent((XValue)XV.toValue((String)contentString));
        CSymbol symbol = factory.createSymbol(id, content, false);
        factSet.addSymbol(symbol);
        return symbol;
    }

    public static CSymbol createAndAddSymbol(CFactory factory, CFactSet factSet, XValue value) {
        XId id = factory.createId();
        CBrowserRenderableContent content = factory.contentFactory().createValueContent(value);
        CSymbol symbol = factory.createSymbol(id, content, false);
        factSet.addSymbol(symbol);
        return symbol;
    }

    public static void createAndAddTriple(CFactory factory, CFactSet factSet, IHasXId s, IHasXId p, IHasXId o) {
        factSet.addTriple(CUtils.createTriple(factory, s, p, o));
    }

    public static void createTriple(CFactory factory, CFactSet dataSet, XId s, XId p, XId o) {
        CTriple t1 = factory.createTriple(s, p, o);
        dataSet.addTriple(t1);
    }

    public static CTriple createTriple(CFactory factory, IHasXId s, IHasXId p, IHasXId o) {
        return factory.createTriple(s.getId(), p.getId(), o.getId());
    }

    public static void factorOutArrayTriples(CFactory factory, CFactSet dataSet) {
        ITripleIndex<XId, XId, XId> index = CUtils.index(dataSet);
        XId zero = factory.getTheIdForIndex(0);
        Iterator it = index.getTriples((Constraint)new Wildcard(), (Constraint)new EqualsConstraint((Object)zero), (Constraint)new Wildcard());
        HashSet<XId> arrayIds = new HashSet<XId>();
        while (it.hasNext()) {
            ITriple t = (ITriple)it.next();
            XId s = (XId)t.s();
            arrayIds.add(s);
        }
        for (XId z : arrayIds) {
            Iterator xyz_it = index.getTriples((Constraint)new Wildcard(), (Constraint)new Wildcard(), (Constraint)new EqualsConstraint((Object)z));
            while (xyz_it.hasNext()) {
                ITriple xyz = (ITriple)xyz_it.next();
                XId x = (XId)xyz.s();
                XId y = (XId)xyz.p();
                assert (xyz.o() == z);
                Iterator zia_it = index.getTriples((Constraint)new EqualsConstraint((Object)z), (Constraint)new Wildcard(), (Constraint)new Wildcard());
                while (zia_it.hasNext()) {
                    ITriple zia = (ITriple)zia_it.next();
                    assert (z == zia.s());
                    XId i = (XId)zia.p();
                    assert (factory.isIndexId(i));
                    XId a = (XId)zia.o();
                    CTriple rem = factory.createTriple(z, i, a);
                    boolean success = dataSet.removeTriple(rem);
                    assert (success) : "Failed to remove " + rem;
                    CTriple add = factory.createTriple(x, y, a);
                    success = dataSet.addTriple(add);
                    assert (success);
                    log.info("Remove " + rem + " add " + add);
                }
                dataSet.removeTriple(factory.createTriple(x, y, z));
            }
        }
    }

    public static byte[] getTripleIdBytes(ITriple<XId, XId, XId> t) {
        return CUtils.combineToBytes((XId)t.s(), (XId)t.p(), (XId)t.o());
    }

    public static byte[] getTripleId(ITriple<XId, XId, XId> t) {
        return CUtils.combineToBytes((XId)t.s(), (XId)t.p(), (XId)t.o());
    }

    public static ITripleIndex<XId, XId, XId> index(CFactSet dataSet) {
        UniformTripleIndex tripleIndex = new UniformTripleIndex();
        Iterator<CTriple> it = dataSet.getTriples();
        while (it.hasNext()) {
            CTriple triple = it.next();
            tripleIndex.index((Object)triple.s(), (Object)triple.p(), (Object)triple.o());
        }
        return tripleIndex;
    }

    public static void replaceIdInTriples(CFactory factory, CFactSet dataSet, XId searchId, XId replaceId) {
        HashSet<CTriple> add = new HashSet<CTriple>();
        HashSet<CTriple> remove = new HashSet<CTriple>();
        Iterator<CTriple> it = dataSet.getTriples();
        while (it.hasNext()) {
            CTriple t = it.next();
            boolean found = false;
            XId s = t.s();
            XId p = t.p();
            XId o = t.o();
            if (s == searchId) {
                found = true;
                s = replaceId;
            }
            if (p == searchId) {
                found = true;
                p = replaceId;
            }
            if (o == searchId) {
                found = true;
                o = replaceId;
            }
            if (!found) continue;
            add.add(factory.createTriple(s, p, o));
            remove.add(t);
        }
        for (CTriple t : remove) {
            dataSet.removeTriple(t);
        }
        for (CTriple t : add) {
            dataSet.addTriple(t);
        }
        log.info("Replace in " + add.size() + " triples");
    }

    public static void summarize(CFactSet factSet) {
        HashSet<XId> sset = new HashSet<XId>();
        HashSet<XId> pset = new HashSet<XId>();
        HashSet<XId> oset = new HashSet<XId>();
        HashSet<XId> symbolIdSet = new HashSet<XId>();
        Iterator<CTriple> tit = factSet.getTriples();
        while (tit.hasNext()) {
            CTriple t = tit.next();
            sset.add(t.s());
            pset.add(t.p());
            oset.add(t.o());
        }
        System.out.println(sset.size() + " distinct s ids");
        System.out.println(pset.size() + " distinct p ids");
        Iterator<CSymbol> sit = factSet.getSymbols();
        while (sit.hasNext()) {
            CSymbol symbol = sit.next();
            symbolIdSet.add(symbol.getId());
            System.out.println(symbol.getId() + " = " + symbol.getContent());
        }
        System.out.println(oset.size() + " distinct o ids");
        HashSet<XId> spset = new HashSet<XId>();
        spset.addAll(sset);
        spset.retainAll(pset);
        System.out.println(spset.size() + " S/\\P");
        HashSet<XId> poset = new HashSet<XId>();
        poset.addAll(pset);
        poset.retainAll(oset);
        System.out.println(poset.size() + " P/\\O");
        HashSet<XId> soset = new HashSet<XId>();
        soset.addAll(sset);
        soset.retainAll(oset);
        System.out.println(soset.size() + " S/\\O");
    }

    private static XId validIdWhichIsRandomIfItMust(byte[] combinedIdBytes) {
        String s;
        int maxStrLen = SimpleUTF8.getMaxCodepoints((byte[])combinedIdBytes);
        ByteBasedIdImpl id = maxStrLen < 100 ? new ByteBasedIdImpl(combinedIdBytes) : (MemoryStringIDProvider.isValidId((String)(s = SimpleUTF8.toUtf8String((byte[])combinedIdBytes))) ? new ByteBasedIdImpl(combinedIdBytes) : Base.createUniqueId());
        return id;
    }
}

