/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.util;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ByteUtils {
    private static final Logger log = LoggerFactory.getLogger(ByteUtils.class);

    public static int compareBytewise(byte[] a, byte[] b) {
        int cmp = a.length - b.length;
        if (cmp != 0) {
            return cmp;
        }
        assert (b.length == a.length);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            int nsigned = a[i] & 0xFF;
            int otherUnsigned = b[i] & 0xFF;
            return nsigned - otherUnsigned;
        }
        return 0;
    }

    public static int bytesToInt(byte[] bytes) {
        switch (bytes.length) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                return bytes[0] & 0xFF;
            }
            case 2: {
                return ((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF);
            }
            case 3: {
                return ((bytes[0] & 0xFF) << 16) + ((bytes[1] & 0xFF) << 8) + (bytes[2] & 0xFF);
            }
            case 4: {
                return ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
            }
        }
        throw new IllegalArgumentException("too many bytes: " + bytes.length + " for an int");
    }

    public static byte[] intToBytes(int i) {
        byte[] bytes = i < 256 ? new byte[]{(byte)i} : (i < 65536 ? new byte[]{(byte)(i >>> 8), (byte)i} : (i < 0x1000000 ? new byte[]{(byte)(i >>> 16), (byte)(i >>> 8), (byte)i} : new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i}));
        return bytes;
    }

    public static String toString(byte[] bytes, String charset) {
        assert (bytes != null);
        assert (charset != null);
        try {
            Charset cs = Charset.forName(charset);
            return new String(bytes, cs);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            log.warn("could not find charset '" + charset + "'", (Throwable)e);
            return null;
        }
    }
}

