/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl;

import de.xam.cmodel.fact.IChangeData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;

public class FileChangeData
implements IChangeData,
Serializable {
    private final File f;

    public FileChangeData(File f) {
        this.f = f;
    }

    @Override
    public String getCreationSource() {
        return FileChangeData.class.getCanonicalName();
    }

    @Override
    public long getLastModifiedUTC() {
        return this.f.lastModified();
    }

    @Override
    public long getCreationDateUTC() {
        BasicFileAttributeView b = Files.getFileAttributeView(this.f.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
        try {
            return b.readAttributes().creationTime().toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
    }

    @Override
    public String getCreatedBy() {
        try {
            return Files.getOwner(this.f.toPath(), new LinkOption[0]).getName();
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
    }

    public String toString() {
        return "file " + this.f.getAbsolutePath() + " modified:" + this.getLastModifiedUTC();
    }
}

