/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact;

import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.impl.ChangeDataImpl;
import de.xam.cmodel.fact.impl.FileChangeData;
import de.xam.p13n.shared.time.TimeProvider;
import java.io.File;

public class ChangeDatas {
    public static IChangeData createFileChangeData(File f) {
        return new FileChangeData(f);
    }

    public static IChangeData createWithCreationDate_Now(String createdBy, String creationSource) {
        long now = TimeProvider.getCurrentTimeInMillis();
        assert (now != 0L);
        return ChangeDataImpl.createWithCreationDate(now, createdBy, creationSource);
    }

    public static IChangeData createWithLastModifiedDate_Now(String createdBy, String creationSource) {
        long now = TimeProvider.getCurrentTimeInMillis();
        return ChangeDataImpl.createWithLastModifiedDate(now, createdBy, creationSource);
    }

    public static long getLastCreationOrModifiedDate(IChangeData changeData) {
        long changeDate = changeData.getLastModifiedUTC();
        if (changeDate > 0L) {
            return changeDate;
        }
        return changeData.getCreationDateUTC();
    }

    public static ChangeDataImpl clone(IChangeData changeData) {
        ChangeDataImpl changeDataCopy = new ChangeDataImpl(changeData.getCreatedBy(), changeData.getCreationSource());
        changeDataCopy.setCreationDateUTC(changeData.getCreationDateUTC());
        changeDataCopy.setLastModifiedUTC(changeData.getLastModifiedUTC());
        return changeDataCopy;
    }

    public static IChangeData cloneLastModifiedNow(IChangeData changeData) {
        ChangeDataImpl changeDataCopy = new ChangeDataImpl(changeData.getCreatedBy(), changeData.getCreationSource());
        changeDataCopy.setCreationDateUTC(changeData.getCreationDateUTC());
        long now = TimeProvider.getCurrentTimeInMillis();
        changeDataCopy.setLastModifiedUTC(now);
        return changeDataCopy;
    }
}

