/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content.impl;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.IContentType;
import java.io.UnsupportedEncodingException;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XValue;

public class MemoryBrec
implements CBrowserRenderableContent {
    private byte[] contentBytes;
    private final String contentTypeUri;
    private XValue contentValue;
    private String contentString;

    public MemoryBrec(XStringValue value, String contentTypeUri) {
        this.contentValue = value;
        this.contentTypeUri = contentTypeUri;
    }

    public MemoryBrec(XBinaryValue value, String contentTypeUri) {
        this.contentValue = value;
        this.contentTypeUri = contentTypeUri;
    }

    public MemoryBrec(String contentString, String contentTypeUri) {
        this.contentString = contentString;
        this.contentTypeUri = contentTypeUri;
    }

    public MemoryBrec(byte[] contentBytes, String contentTypeUri) {
        this.contentBytes = contentBytes;
        this.contentTypeUri = contentTypeUri;
    }

    @Override
    public String getContentTypeUri() {
        return this.contentTypeUri;
    }

    @Override
    public long getContentLength() {
        if (this.contentString != null) {
            return this.contentString.length();
        }
        if (this.contentBytes != null) {
            return this.contentBytes.length;
        }
        if (this.contentValue != null) {
            if (this.contentValue instanceof XStringValue) {
                return ((XStringValue)this.contentValue).contents().length();
            }
            if (this.contentValue instanceof XStringValue) {
                return ((XBinaryValue)this.contentValue).getValue().length;
            }
        }
        return -1L;
    }

    @Override
    public XValue getContentValue() {
        if (this.contentValue == null) {
            throw new IllegalStateException("Content is not based on a Xydra value");
        }
        return this.contentValue;
    }

    @Override
    public String getContentAsString() {
        if (this.contentString != null) {
            return this.contentString;
        }
        IContentType contentType = ContentTypes.parseUri(this.getContentTypeUri());
        if (!contentType.isStringType()) {
            return null;
        }
        if (this.contentBytes != null) {
            return MemoryBrec.toString(this.contentBytes, contentType);
        }
        if (this.contentValue != null) {
            if (this.contentValue instanceof XStringValue) {
                return ((XStringValue)this.contentValue).contents();
            }
            if (this.contentValue instanceof XBinaryValue) {
                byte[] bytes = ((XBinaryValue)this.contentValue).getValue();
                return MemoryBrec.toString(bytes, contentType);
            }
        }
        return null;
    }

    private static String toString(byte[] contentBytes, IContentType contentType) {
        String s;
        String charset = contentType.getCharset();
        try {
            s = new String(contentBytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error", e);
        }
        return s;
    }

    @Override
    public byte[] getContentAsBytes() {
        return this.contentBytes;
    }
}

