/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content.impl;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.CWritableBrowserRenderableContent;
import de.xam.cmodel.content.XydraContentType;
import de.xam.texthtml.text.Unicodes;
import java.nio.ByteBuffer;
import org.xydra.base.XId;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XBooleanValue;
import org.xydra.base.value.XDoubleValue;
import org.xydra.base.value.XIntegerValue;
import org.xydra.base.value.XLongValue;
import org.xydra.base.value.XValue;

public class BrecNativeXydraValue
implements CWritableBrowserRenderableContent {
    private XValue value;

    public BrecNativeXydraValue(XValue value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public String getContentTypeUri() {
        return XydraContentType.toXydraTypeUri(this.value.getType());
    }

    @Override
    public XValue getContentValue() {
        return this.value;
    }

    @Override
    public String getContentAsString() {
        if (XydraContentType.isXydraStringType(this.value.getType())) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public byte[] getContentAsBytes() {
        switch (this.value.getType()) {
            case Address: 
            case String: {
                assert (XydraContentType.isXydraStringType(this.value.getType()));
                return this.value.toString().getBytes(Unicodes.UTF8);
            }
            case AddressList: 
            case AddressSet: 
            case AddressSortedSet: 
            case BooleanList: 
            case DoubleList: 
            case IdList: 
            case IdSet: 
            case IdSortedSet: 
            case IntegerList: 
            case LongList: 
            case StringList: 
            case StringSet: {
                throw new RuntimeException("not impl");
            }
            case Binary: {
                return ((XBinaryValue)this.value).getValue();
            }
            case Id: {
                return ((XId)this.value).toBytes();
            }
            case Boolean: {
                return new byte[(byte)(((XBooleanValue)this.value).contents() ? 255 : 0)];
            }
            case Double: {
                double d = ((XDoubleValue)this.value).contents();
                return ByteBuffer.allocate(8).putDouble(d).array();
            }
            case Integer: {
                int i = ((XIntegerValue)this.value).contents();
                return ByteBuffer.allocate(4).putInt(i).array();
            }
            case Long: {
                long l = ((XLongValue)this.value).contents();
                return ByteBuffer.allocate(8).putLong(l).array();
            }
            case Null: {
                return new byte[0];
            }
        }
        throw new AssertionError();
    }

    @Override
    public long getContentLength() {
        switch (this.value.getType()) {
            case Address: 
            case String: {
                assert (XydraContentType.isXydraStringType(this.value.getType()));
                return this.value.toString().length();
            }
            case AddressList: 
            case AddressSet: 
            case AddressSortedSet: 
            case BooleanList: 
            case DoubleList: 
            case IdList: 
            case IdSet: 
            case IdSortedSet: 
            case IntegerList: 
            case LongList: 
            case StringList: 
            case StringSet: {
                throw new RuntimeException("not impl");
            }
            case Binary: {
                return ((XBinaryValue)this.value).getValue().length;
            }
            case Id: {
                return ((XId)this.value).toBytes().length;
            }
            case Boolean: {
                return 1L;
            }
            case Double: {
                return 8L;
            }
            case Integer: {
                return 4L;
            }
            case Long: {
                return 8L;
            }
            case Null: {
                return 1L;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void setContent(String contentString, String contentTypeUri, long lastModified) {
        throw new UnsupportedOperationException("a native brec instance cannot store contentTypeUris");
    }

    @Override
    public void setContent(byte[] contentBytes, String contentTypeUri, long lastModified) {
        throw new UnsupportedOperationException("a native brec instance cannot store contentTypeUris");
    }

    @Override
    public boolean setContent(XValue contentValue, String contentTypeUri, long lastModified) {
        if (XydraContentType.toXydraTypeUri(this.value.getType()).equals(contentTypeUri)) {
            if (this.value.equals(contentValue)) {
                return false;
            }
            this.value = contentValue;
            return true;
        }
        throw new UnsupportedOperationException("a native brec instance cannot store contentTypeUris");
    }

    @Override
    public boolean setContent(XValue contentValue, long lastModified) {
        return this.setContent(contentValue, XydraContentType.toXydraTypeUri(contentValue.getType()), lastModified);
    }

    @Override
    public boolean setContent(CBrowserRenderableContent content, long lastModified) {
        return this.setContent(content.getContentValue(), content.getContentTypeUri(), lastModified);
    }
}

