/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.AbstractContentType;
import de.xam.cmodel.content.IContentType;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.annotations.LicenseApache;
import org.xydra.index.IPair;

public class IanaContentType
extends AbstractContentType
implements IContentType {
    @LicenseApache(copyright="Copyright (c) 2006 Google Inc.")
    private static String _TOKEN = "[\\p{ASCII}&&[^\\p{Cntrl} ;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+";
    public static final IContentType APPLICATION__OCTECT_STREAM = new IanaContentType(IanaRegistrationTree.StandardsTree, IanaTopLevelTypeName.Application, "octet-stream", false, new IPair[0]);
    public static final IContentType APPLICATION_XML = new IanaContentType(IanaRegistrationTree.StandardsTree, IanaTopLevelTypeName.Application, "xml", true, new IPair[0]);
    @LicenseApache(copyright="Copyright (c) 2006 Google Inc.")
    private static Pattern ATTR_PATTERN = Pattern.compile("\\s*;\\s*(" + _TOKEN + ")" + "\\s*=\\s*" + "(?:" + "\"([^\"]*)\"" + "|" + "(" + _TOKEN + ")?" + ")");
    public static final String IANA_PARAMETER_CHARSET = "charset";
    public static final String IANA_VALUE_UTF8 = "utf-8";
    public static final IanaContentType IMAGE_JPG = new IanaContentType(IanaRegistrationTree.StandardsTree, IanaTopLevelTypeName.Image, "jpg", false, new IPair[0]);
    public static final IanaContentType IMAGE_PNG = new IanaContentType(IanaRegistrationTree.StandardsTree, IanaTopLevelTypeName.Image, "png", false, new IPair[0]);
    public static final String PREFIX_IANA_URI = "http://purl.org/NET/mediatypes/";
    public static final IanaContentType TEXT_PLAIN = new IanaContentType(IanaRegistrationTree.StandardsTree, IanaTopLevelTypeName.Text, "plain", true, new IPair[0]);
    @LicenseApache(copyright="Copyright (c) 2006 Google Inc.")
    private static Pattern TOKEN_PATTERN = Pattern.compile("^" + _TOKEN + "$");
    @LicenseApache(copyright="Copyright (c) 2006 Google Inc.")
    private static Pattern TYPE_PATTERN = Pattern.compile("(" + _TOKEN + ")" + "/" + "(" + _TOKEN + ")" + "\\s*(.*)\\s*", 32);
    private final String contentSubtype;
    private String contentType;
    private String datatypeUri;
    private final IanaRegistrationTree ianaRegistrationTree;
    private SortedMap<String, String> parameters;
    private final IanaTopLevelTypeName topLevelTypeName;
    private String ianaContentTypeString;

    private static boolean isIanaStringType(String ianaContentType) {
        return ianaContentType.equals((Object)IanaTopLevelTypeName.Text);
    }

    public static boolean isIanaUri(String contentTypeUri) {
        return contentTypeUri.startsWith(PREFIX_IANA_URI);
    }

    public static void main(String[] args) {
        System.out.println(IanaContentType.to_IANA_URI("text", "plain", IANA_VALUE_UTF8));
        System.out.println(APPLICATION__OCTECT_STREAM.getAsIanaContentTypeString());
    }

    @LicenseApache(copyright="Copyright (c) 2006 Google Inc.", modified=true)
    public static IanaContentType parseIanaContentType(String ianaContentType) {
        assert (ianaContentType != null);
        Matcher typeMatch = TYPE_PATTERN.matcher(ianaContentType);
        if (!typeMatch.matches()) {
            throw new IllegalArgumentException("Invalid media type:" + ianaContentType);
        }
        String contentTypeStr = typeMatch.group(1).toLowerCase();
        String contentSubtypeStr = typeMatch.group(2).toLowerCase();
        IanaTopLevelTypeName contentType = IanaTopLevelTypeName.parse(contentTypeStr);
        IanaContentType result = new IanaContentType(IanaRegistrationTree.StandardsTree, contentType, contentSubtypeStr, IanaContentType.isIanaStringType(contentTypeStr), new IPair[0]);
        if (typeMatch.groupCount() < 3) {
            return result;
        }
        Matcher attrMatch = ATTR_PATTERN.matcher(typeMatch.group(3));
        while (attrMatch.find()) {
            String value = attrMatch.group(2);
            if (value == null && (value = attrMatch.group(3)) == null) {
                value = "";
            }
            result.setParameter(attrMatch.group(1).toLowerCase(), value);
        }
        return result;
    }

    public static IanaContentType parseIanaUri(String contentTypeUri) {
        assert (IanaContentType.isIanaUri(contentTypeUri));
        String def = contentTypeUri.substring(PREFIX_IANA_URI.length());
        IanaContentType result = IanaContentType.parseIanaContentType(def);
        return result;
    }

    public static String to_IANA_URI(String fullContentType) {
        assert (fullContentType != null);
        return PREFIX_IANA_URI + fullContentType;
    }

    public static String to_IANA_URI(String mediaType, String mediaSubtype) {
        assert (mediaType != null);
        assert (mediaSubtype != null);
        return IanaContentType.to_IANA_URI(mediaType + "/" + mediaSubtype);
    }

    public static String to_IANA_URI(String mediaType, String mediaSubtype, String charset) {
        assert (mediaType != null);
        assert (mediaSubtype != null);
        return mediaType + "/" + mediaSubtype + (charset == null ? "" : ";charset=" + charset);
    }

    public static String toDatatypeUri(IanaContentType ianaContentType) {
        String uri = PREFIX_IANA_URI + IanaContentType.toIanaContentTypeString(ianaContentType.topLevelTypeName.getToken(), IanaRegistrationTree.StandardsTree.getFacet(), ianaContentType.getContentSubtype(), ianaContentType.parameters);
        return uri;
    }

    public static String toIanaContentTypeString(String topLevelTypeName, String facet, String contentSubtype, Map<String, String> parameters) {
        StringBuilder b = new StringBuilder();
        b.append(topLevelTypeName + "/" + facet + contentSubtype);
        if (parameters != null) {
            b.append(";");
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                String name = e.getKey();
                String value = e.getValue();
                b.append(name);
                b.append("=");
                b.append(value);
            }
        }
        return b.toString();
    }

    @SafeVarargs
    public IanaContentType(IanaRegistrationTree ianaRegistrationTree, IanaTopLevelTypeName topLevelTypeName, String contentSubtype, boolean isStringType, IPair<String, String> ... parameters) {
        super(AbstractContentType.TypeSystem.Iana, isStringType);
        assert (ianaRegistrationTree != null);
        assert (topLevelTypeName != null);
        assert (contentSubtype != null);
        this.ianaRegistrationTree = ianaRegistrationTree;
        this.topLevelTypeName = topLevelTypeName;
        this.contentSubtype = contentSubtype.toLowerCase();
        if (parameters != null) {
            this.parameters = new TreeMap<String, String>();
            for (IPair<String, String> pair : parameters) {
                if (pair == null) continue;
                this.parameters.put((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        if (isStringType && this.getParameter(IANA_PARAMETER_CHARSET) == null) {
            this.setParameter(IANA_PARAMETER_CHARSET, IANA_VALUE_UTF8);
        }
    }

    @Override
    public String getAsIanaContentTypeString() {
        if (this.ianaContentTypeString == null) {
            this.ianaContentTypeString = IanaContentType.toIanaContentTypeString(this.topLevelTypeName.getToken(), this.ianaRegistrationTree.getFacet(), this.contentSubtype, this.parameters);
        }
        return this.ianaContentTypeString;
    }

    @Override
    public String getCharset() {
        if (!this.isStringType()) {
            return null;
        }
        String value = this.getParameter(IANA_PARAMETER_CHARSET);
        if (value == null) {
            return IANA_VALUE_UTF8;
        }
        return value;
    }

    public String getContentSubtype() {
        return this.contentSubtype;
    }

    public String getContentType() {
        return this.contentType;
    }

    public IanaRegistrationTree getIanaRegistrationTree() {
        return this.ianaRegistrationTree;
    }

    @Override
    public String getNativeString() {
        return this.getAsIanaContentTypeString();
    }

    public String getParameter(String name) {
        if (this.parameters != null) {
            return (String)this.parameters.get(name);
        }
        return null;
    }

    @Override
    public String getUri() {
        if (this.datatypeUri == null) {
            this.datatypeUri = IanaContentType.toDatatypeUri(this);
        }
        return this.datatypeUri;
    }

    protected void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, String>();
        }
        this.parameters.put(name.toLowerCase(), value);
    }

    public String toContentTypeValue() {
        return IanaContentType.toIanaContentTypeString(this.contentType, this.contentType, this.contentSubtype, this.parameters);
    }

    @Override
    public String toString() {
        return "IanaContentType [" + super.toString() + " >> " + "tree=" + (Object)((Object)this.ianaRegistrationTree) + ", topLevelType=" + this.contentType + ", subtype=" + this.contentSubtype + ", parameters=" + this.parameters + "]";
    }

    public boolean contains(IContentType contentType) {
        if (contentType instanceof IanaContentType) {
            return this.containsIanaContentType((IanaContentType)contentType);
        }
        return false;
    }

    private boolean containsIanaContentType(IanaContentType contentType) {
        if (this.getIanaRegistrationTree() != contentType.getIanaRegistrationTree()) {
            return false;
        }
        if (this.topLevelTypeName != contentType.topLevelTypeName) {
            return false;
        }
        return this.contentSubtype.equals(contentType.contentSubtype);
    }

    public static enum IanaTopLevelTypeName {
        Application("application"),
        Audio("audio"),
        Image("image"),
        Message("message"),
        Multipart("multipart"),
        Text("text"),
        Video("video"),
        X_Token("x-");

        private String token;

        private IanaTopLevelTypeName(String token) {
            this.token = token;
        }

        public static IanaTopLevelTypeName parse(String token) {
            for (IanaTopLevelTypeName typeName : IanaTopLevelTypeName.values()) {
                if (!typeName.getToken().equals(token.toLowerCase())) continue;
                return typeName;
            }
            return null;
        }

        public String getToken() {
            return this.token;
        }
    }

    public static enum IanaRegistrationTree {
        PersonalVanityTree("prs."),
        StandardsTree(""),
        UnregisteredXTree("x."),
        VendorTree("vnd.");

        private String facet;

        private IanaRegistrationTree(String facet) {
            this.facet = facet;
        }

        public String getFacet() {
            return this.facet;
        }
    }
}

