/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.CContentFactory;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.content.XydraContentType;
import de.xam.cmodel.content.impl.MemoryBrec;
import de.xam.texthtml.text.Unicodes;
import org.xydra.base.XAddress;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XValue;
import org.xydra.base.value.XValueJavaUtils;

public class Contents {
    public static byte[] getContentAsBytes(XValue value) {
        if (value == null) {
            return null;
        }
        if (value.getType() == ValueType.Binary) {
            return ((XBinaryValue)value).getValue();
        }
        if (XydraContentType.isXydraStringType(value.getType())) {
            String s = Contents.getString(value);
            return s.getBytes(Unicodes.UTF8);
        }
        throw new IllegalStateException();
    }

    public static String getContentAsString(XValue value) {
        if (value == null) {
            return null;
        }
        if (value.getType() == ValueType.Binary) {
            return null;
        }
        if (XydraContentType.isXydraStringType(value.getType())) {
            String s = Contents.getString(value);
            return s;
        }
        if (value.getType() == ValueType.Boolean) {
            return value.toString();
        }
        throw new IllegalStateException("Content is neither null, nor binary, nor a known string type but '" + value.getType() + "'");
    }

    public static long getContentLength(XValue value) {
        if (value == null) {
            return -1L;
        }
        if (value.getType() == ValueType.Binary) {
            return ((XBinaryValue)value).getValue().length;
        }
        if (XydraContentType.isXydraStringType(value.getType())) {
            String s = Contents.getString(value);
            return s.length();
        }
        throw new IllegalStateException();
    }

    public static CBrowserRenderableContent copy(CBrowserRenderableContent content) {
        XValue value = content.getContentValue();
        assert (value != null);
        if (value instanceof XStringValue) {
            return new MemoryBrec((XStringValue)value, content.getContentTypeUri());
        }
        if (value instanceof XBinaryValue) {
            return new MemoryBrec((XBinaryValue)value, content.getContentTypeUri());
        }
        throw new IllegalArgumentException("Cannot handle Xydra value type " + value.getType());
    }

    public static String toString(CBrowserRenderableContent content) {
        if (content == null) {
            return null;
        }
        return content.getContentAsString();
    }

    public static CBrowserRenderableContent createStringContent(CContentFactory contentFactory, String contentString, IContentType contentType) {
        if (!contentType.isStringType()) {
            throw new IllegalArgumentException();
        }
        String uri = contentType.getUri();
        if (XydraContentType.isXydraUri(uri)) {
            ValueType valueType = XydraContentType.valueOfLowercaseXydraTypename(contentType.getNativeString());
            assert (valueType != null);
            XValue value = XValueJavaUtils.toValue((String)contentString, (ValueType)valueType);
            return contentFactory.createValueContent(value);
        }
        return contentFactory.createStringContent(contentString, contentType.getUri());
    }

    public static CBrowserRenderableContent createBinaryContent(CContentFactory contentFactory, byte[] contentBytes, IContentType contentType) {
        if (contentType.isStringType()) {
            throw new IllegalArgumentException("ContentType " + contentType + " is string-based");
        }
        return contentFactory.createBinaryContent(contentBytes, contentType.getUri());
    }

    public static boolean isStringContent(CBrowserRenderableContent content) {
        return ContentTypes.isStringType(content.getContentTypeUri());
    }

    public static String getString(XValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getType()) {
            case Address: {
                return ((XAddress)((XAddress)value).getValue()).toURI();
            }
            case String: {
                return (String)((XStringValue)value).getValue();
            }
            case Id: {
                return value.toString();
            }
            case Long: {
                return value.toString();
            }
        }
        return null;
    }
}

