/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.AnyUriContentType;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.content.IanaContentType;
import de.xam.cmodel.content.XsdContentType;
import de.xam.cmodel.content.XydraContentType;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentTypes {
    private static final Map<String, IContentType> contentTypeIdentifier2contentTypeInstance = new HashMap<String, IContentType>();
    public static final Pattern PATTERN_START_IANA_CONTENTTYPE = Pattern.compile("[a-z0-9][-a-z0-9!#$&^_.+]*[/]");
    public static final Pattern PATTERN_START_URI = Pattern.compile("[a-z][a-z0-9+-.]*[:]");
    private static final Map<IContentType, String> contentType2canonicalUri = new HashMap<IContentType, String>();
    private static final Map<IContentType, String> contentType2canonicalIanaString = new HashMap<IContentType, String>();

    public static IContentType parseContentTypeIdentifier(String contentTypeIdentifier) {
        if (ContentTypes.isUriInsteadofIanaContentType(contentTypeIdentifier)) {
            return ContentTypes.parseUri(contentTypeIdentifier);
        }
        return IanaContentType.parseIanaContentType(contentTypeIdentifier);
    }

    public static IContentType parseUri(String contentTypeUri) {
        if (XsdContentType.isXsdUri(contentTypeUri)) {
            return XsdContentType.parseXsdUri(contentTypeUri);
        }
        if (IanaContentType.isIanaUri(contentTypeUri)) {
            return IanaContentType.parseIanaUri(contentTypeUri);
        }
        if (XydraContentType.isXydraUri(contentTypeUri)) {
            return XydraContentType.parseXydraUri(contentTypeUri);
        }
        if (AnyUriContentType.isAnyUri(contentTypeUri)) {
            return AnyUriContentType.parseAnyUri(contentTypeUri);
        }
        throw new IllegalArgumentException("Cannot parse uri '" + contentTypeUri + "', unknown prefix");
    }

    public static boolean isStringType(String contentTypeUri) {
        return ContentTypes.parseUri(contentTypeUri).isStringType();
    }

    public static IContentType getContentType(String contentTypeIdentifier) {
        IContentType contentType = contentTypeIdentifier2contentTypeInstance.get(contentTypeIdentifier);
        if (contentType == null) {
            contentType = ContentTypes.createContentType(contentTypeIdentifier);
            contentTypeIdentifier2contentTypeInstance.put(contentTypeIdentifier, contentType);
        }
        return contentType;
    }

    private static IContentType createContentType(String contentTypeIdentifier) {
        if (ContentTypes.isUriInsteadofIanaContentType(contentTypeIdentifier)) {
            if (XydraContentType.isXydraUri(contentTypeIdentifier)) {
                return XydraContentType.parseXydraUri(contentTypeIdentifier);
            }
            assert (XsdContentType.isXsdUri(contentTypeIdentifier));
            return XsdContentType.parseXsdUri(contentTypeIdentifier);
        }
        return IanaContentType.parseIanaContentType(contentTypeIdentifier);
    }

    public static boolean isUriInsteadofIanaContentType(String contentTypeIdentifier) {
        boolean isIana;
        Matcher mUri = PATTERN_START_URI.matcher(contentTypeIdentifier);
        boolean isUri = mUri.find() && mUri.start() == 0;
        Matcher mIana = PATTERN_START_IANA_CONTENTTYPE.matcher(contentTypeIdentifier);
        boolean bl = isIana = mIana.find() && mIana.start() == 0;
        assert (isUri ^ isIana) : "contentTypeId format '" + contentTypeIdentifier + "'";
        return isUri;
    }

    public static String getCanonicalIanaString(IContentType contentType) {
        String contentTypeIanaString = contentType2canonicalIanaString.get(contentType);
        if (contentTypeIanaString == null) {
            contentTypeIanaString = contentType.getAsIanaContentTypeString();
            contentType2canonicalIanaString.put(contentType, contentTypeIanaString);
        }
        return contentTypeIanaString;
    }

    public static void defineCanonicalUri(IContentType contentType, String canonicalUri) {
        contentType2canonicalUri.put(contentType, canonicalUri);
    }

    public static void defineCanonicalIanaString(IContentType contentType, String canonicalIanaString) {
        contentType2canonicalIanaString.put(contentType, canonicalIanaString);
    }

    public static String getCanonicalUri(IContentType contentType) {
        String contentTypeUri = contentType2canonicalUri.get(contentType);
        if (contentTypeUri == null) {
            contentTypeUri = contentType.getUri();
            contentType2canonicalUri.put(contentType, contentTypeUri);
        }
        return contentTypeUri;
    }

    public static void registerContentType(IContentType contentType) {
        contentTypeIdentifier2contentTypeInstance.put(contentType.getUri(), contentType);
    }

    public static void main(String[] args) {
        String[] xydraUri;
        for (String s : xydraUri = new String[]{"http://purl.org/net/xydra/datatypes#String", "http://purl.org/net/xydra/datatypes#string"}) {
            assert (ContentTypes.isUriInsteadofIanaContentType(s));
            assert (XydraContentType.parseXydraUri(s) != null);
            assert (ContentTypes.parseUri(s) != null);
        }
    }

    static {
        ContentTypes.defineCanonicalIanaString(XsdContentType.XSD_STRING, IanaContentType.TEXT_PLAIN.getAsIanaContentTypeString());
        ContentTypes.defineCanonicalIanaString(XydraContentType.STRING, IanaContentType.TEXT_PLAIN.getAsIanaContentTypeString());
        ContentTypes.defineCanonicalUri(IanaContentType.TEXT_PLAIN, XsdContentType.XSD_STRING.getUri());
        ContentTypes.defineCanonicalUri(XydraContentType.STRING, XsdContentType.XSD_STRING.getUri());
        ContentTypes.defineCanonicalUri(XydraContentType.BOOLEAN, XsdContentType.XSD_BOOLEAN.getUri());
        ContentTypes.defineCanonicalUri(XydraContentType.DOUBLE, XsdContentType.XSD_DOUBLE.getUri());
        ContentTypes.defineCanonicalUri(XydraContentType.INT, XsdContentType.XSD_INT.getUri());
    }
}

