/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.AbstractContentType;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.IContentType;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class AnyUriContentType
extends AbstractContentType
implements IContentType {
    private static Map<String, AnyUriContentType> uri2ct = new HashMap<String, AnyUriContentType>();
    private final String uri;

    public static AnyUriContentType parseAnyUri(String contentTypeUri) {
        assert (AnyUriContentType.isAnyUri(contentTypeUri));
        AnyUriContentType previouslyCreatedContentType = uri2ct.get(contentTypeUri);
        if (previouslyCreatedContentType != null) {
            return previouslyCreatedContentType;
        }
        boolean isStringType = false;
        AnyUriContentType result = new AnyUriContentType(contentTypeUri, false);
        return result;
    }

    public static boolean isAnyUri(String contentTypeUri) {
        Matcher m = ContentTypes.PATTERN_START_URI.matcher(contentTypeUri);
        return m.find() && m.start() == 0;
    }

    public AnyUriContentType(String uri, boolean isStringType) {
        super(AbstractContentType.TypeSystem.AnyUri, isStringType);
        assert (uri != null);
        this.uri = uri;
        uri2ct.put(uri, this);
        assert (uri2ct.size() < 1000) : "Why are so many different contentType URIs registered?";
    }

    @Override
    public String getAsIanaContentTypeString() {
        return null;
    }

    @Override
    public String getNativeString() {
        return this.uri;
    }

    @Override
    public String getUri() {
        return this.uri;
    }
}

