/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.util.NxUtil;
import org.semanticweb.yars.util.CallbackBlockingQueue;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;
import org.semanticweb.yars2.rdfxml.ParserThread;
import org.semanticweb.yars2.rdfxml.RDFXMLParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLParser
implements Iterator<Node[]> {
    private BlockingQueue<Node[]> _q = null;
    private boolean _done = false;
    private Exception _e = null;
    private ParserThread _pt = null;
    private Node[] _current = null;
    private Resource _con = null;
    public static final int DEFAULT_BUFFER = 1000;
    public static final int TIME_OUT = 1000;
    private SAXParser _parser;

    public RDFXMLParser(InputStream in, String baseURI) throws ParseException, IOException {
        this(in, false, true, baseURI, 1000);
    }

    public RDFXMLParser(InputStream in, boolean strict, boolean skolemise, String baseURI) throws ParseException, IOException {
        this(in, strict, skolemise, baseURI, 1000);
    }

    public RDFXMLParser(InputStream in, boolean strict, boolean skolemise, String baseURI, int buffer) throws ParseException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            this._parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        try {
            this._q = new ArrayBlockingQueue<Node[]>(buffer);
            CallbackBlockingQueue bcb = new CallbackBlockingQueue(this._q);
            this._pt = new ParserThread(this._parser, in, new RDFXMLParserBase(baseURI, bcb, skolemise), this._q);
            this._pt.start();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public RDFXMLParser(InputStream in, boolean strict, boolean skolemise, String baseURI, Callback c) throws ParseException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            this._parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(strict);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new RDFXMLParserBase(baseURI, c, skolemise));
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public RDFXMLParser(InputStream in, boolean strict, boolean skolemise, String baseURI, Callback c, Resource con) throws ParseException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            this._parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this._con = con;
        factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(strict);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new RDFXMLParserBase(baseURI, c, skolemise, con));
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public Resource getContext() {
        return this._con;
    }

    @Override
    public boolean hasNext() {
        if (this._q == null) {
            return false;
        }
        if (this._done) {
            return false;
        }
        if (this._current != null) {
            if (this._current.length == 0) {
                this._done = true;
                this._e = this._pt.getException();
                return false;
            }
            return true;
        }
        if (this._q.size() > 0) {
            this._current = (Node[])this._q.poll();
            return this.hasNext();
        }
        try {
            this._current = this._q.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this._done = true;
            return false;
        }
        return this.hasNext();
    }

    @Override
    public Node[] next() {
        if (this._current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] result = new Node[this._current.length];
        System.arraycopy(this._current, 0, result, 0, this._current.length);
        this._current = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuccess() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    public static void main(String[] args) throws FileNotFoundException, ParseException, IOException, URISyntaxException {
        String baseUri = "http://sw.deri.org/~aidanh/foaf/foaf.rdf";
        URL u = new URL(baseUri);
        HttpURLConnection uc = (HttpURLConnection)u.openConnection();
        System.err.println("opening parser");
        CallbackNxBufferedWriter cb = new CallbackNxBufferedWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        RDFXMLParser rxp = new RDFXMLParser(uc.getInputStream(), false, false, baseUri, cb, new Resource(NxUtil.escapeForNx(baseUri)));
        System.err.println("reading data");
        while (rxp.hasNext()) {
            System.err.println(Nodes.toN3(rxp.next()));
        }
    }
}

