/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util.thread;

import java.util.concurrent.BlockingQueue;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerThread
extends Thread {
    int _ticks = Main.TICKS;
    static int _thread_count = 0;
    Callback _cb;
    BlockingQueue<Node[]> _q;
    InterruptedException _e;
    int _eofs = 1;
    int _done = 0;

    public ConsumerThread(Callback cb, BlockingQueue<Node[]> q) {
        this(cb, q, 1);
    }

    public void setTicks(int ticks) {
        this._ticks = ticks;
    }

    public ConsumerThread(Callback cb, BlockingQueue<Node[]> q, int eofs) {
        super(ConsumerThread.class.getName() + _thread_count);
        ++_thread_count;
        this._cb = cb;
        this._q = q;
        this._eofs = eofs;
    }

    @Override
    public void run() {
        int i = 0;
        this._cb.startDocument();
        try {
            while (this._done < this._eofs) {
                Node[] na;
                if (this._ticks > 0 && ++i % this._ticks == 0) {
                    System.err.println(this.getName() + " done " + i);
                }
                if ((na = this._q.take()).equals(Nodes.EOM)) {
                    ++this._done;
                    continue;
                }
                this._cb.processStatement(na);
            }
        }
        catch (InterruptedException e) {
            this._e = e;
        }
        this._cb.endDocument();
    }

    public boolean successful() {
        return this._e == null;
    }

    public InterruptedException getException() {
        return this._e;
    }
}

