/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.yars.util.LRUMapCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUSetCache<E>
extends AbstractSet<E>
implements Set<E> {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_CACHE_SIZE = 100;
    public static float DEFAULT_LOAD_FACTOR = 0.75f;
    LRUMapCache<E, E> _map;

    public LRUSetCache() {
        this(DEFAULT_CACHE_SIZE, DEFAULT_LOAD_FACTOR);
    }

    public LRUSetCache(int cache) {
        this(cache, DEFAULT_LOAD_FACTOR);
    }

    public LRUSetCache(int cache, float loadFactor) {
        this._map = new LRUMapCache(cache, loadFactor);
    }

    @Override
    public boolean add(E e) {
        return this._map.put(e, e) == null;
    }

    @Override
    public boolean contains(Object e) {
        return this._map.containsKey(e);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        return this._map.remove(arg0) != null;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

