/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSortedIterator
implements Iterator<Node[]> {
    Iterator<Node[]> _in;
    Node[] _old = null;
    Comparator<Node[]> _nc;
    NotSortedException _last = null;
    static transient Logger _log = Logger.getLogger(CheckSortedIterator.class.getName());

    public CheckSortedIterator(Iterator<Node[]> iter) {
        this(iter, NodeComparator.NC);
    }

    public CheckSortedIterator(Iterator<Node[]> iter, Comparator<Node[]> nc) {
        this._in = iter;
        this._nc = nc;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    public NotSortedException getException() {
        return this._last;
    }

    public boolean isOkay() {
        return this._last == null;
    }

    @Override
    public Node[] next() {
        int comp;
        Node[] next = this._in.next();
        if (this._old != null && (comp = this._nc.compare(this._old, next)) > 0 && comp != -2147480429) {
            this._last = new NotSortedException(this._old, next);
            _log.severe(this._last.getMessage());
        }
        this._old = next;
        return next;
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public static void main(String[] args) {
        Node[] a = new Node[]{new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.html"), new Resource("http://rdfs.org/sioc/ns#title"), new Literal("Database"), new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.sioc.rdf")};
        Node[] b = new Node[]{new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.html"), new Resource("http://rdfs.org/sioc/ns#title"), new Literal("Creating Free Text Indexes"), new Resource("http://docs.openlinksw.com/virtuoso/virtdocs.sioc.rdf")};
        System.err.println(NodeComparator.NC.compare(a, b));
    }

    public static class NotSortedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Node[] _a;
        private Node[] _b;

        public NotSortedException(String msg) {
            super(msg);
        }

        public NotSortedException(Node[] a, Node[] b) {
            super(NotSortedException.createMessage(a, b));
            this._a = a;
            this._b = b;
        }

        public Node[] getFirstNodes() {
            return this._a;
        }

        public Node[] getSecondNodes() {
            return this._b;
        }

        static String createMessage(Node[] a, Node[] b) {
            StringBuffer buf = new StringBuffer();
            buf.append("#########Not sorted!#########\n");
            buf.append(" " + Nodes.toN3(a) + " before\n");
            buf.append(" " + Nodes.toN3(b) + "\n");
            return buf.toString();
        }
    }
}

