/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.tld;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.yars.tld.Tld;

public class TldManager {
    private static Logger _log = Logger.getLogger(TldManager.class.getName());
    HashMap<String, Tld> TLDs = null;

    public TldManager() throws IOException {
        this.read(TldManager.class.getResourceAsStream("tld.dat"));
    }

    void read(InputStream is) throws IOException {
        this.TLDs = new HashMap();
        if (is == null) {
            throw new IOException("input stream is null");
        }
        this.readList(is);
    }

    public String getPLD(URI url) {
        try {
            if (url.getScheme() == null) {
                _log.info("no scheme: " + url);
                return null;
            }
            if (!url.getScheme().equalsIgnoreCase("http") && !url.getScheme().equalsIgnoreCase("https")) {
                _log.info("scheme not http(s) " + url);
                return null;
            }
            String host = url.getHost().toLowerCase();
            if (host == null) {
                _log.fine("no host for " + url);
                return null;
            }
            String[] parts = host.split("\\.");
            if (parts.length == 1) {
                _log.info("no TLD " + url);
                return host;
            }
            if (parts.length == 2) {
                return host;
            }
            String tld = host.substring(host.lastIndexOf(".") + 1, host.length());
            Tld current = this.TLDs.get(tld);
            if (current == null) {
                _log.info("no TLD " + url);
                return host;
            }
            if (parts.length == 3) {
                if (current.getHasOneLvlSffxes()) {
                    if (current.getAddlTwoLvlSffxes().contains(parts[1] + "." + parts[2])) {
                        return host;
                    }
                    if (current.getExcptnlThreeLvlDomains().contains(host)) {
                        return host;
                    }
                    return parts[1] + "." + parts[2];
                }
                if (current.getHasTwoLvlSffxes()) {
                    if (current.getExcptnlTwoLvlDomains().contains(parts[1] + "." + parts[2])) {
                        return parts[1] + "." + parts[2];
                    }
                    return host;
                }
                if (current.getAddlTwoLvlSffxes().contains(parts[1] + "." + parts[2])) {
                    return host;
                }
                if (current.getExcptnlThreeLvlDomains().contains(host)) {
                    return host;
                }
                _log.info("? TLD " + url);
                return host;
            }
            host = parts[parts.length - 4] + "." + parts[parts.length - 3] + "." + parts[parts.length - 2] + "." + parts[parts.length - 1];
            if ((parts = host.split("\\."))[3].equals("us") && parts[2].length() == 2 && current.getAddlTwoLvlSffxes().contains(parts[2] + "." + parts[3])) {
                return host;
            }
            if (current.getHasOneLvlSffxes()) {
                if (current.getAddlThreeLvlSffxes().contains(parts[1] + "." + parts[2] + "." + parts[3])) {
                    return host;
                }
                if (current.getAddlTwoLvlSffxes().contains(parts[2] + "." + parts[3])) {
                    return parts[1] + "." + parts[2] + "." + parts[3];
                }
                if (current.getExcptnlThreeLvlDomains().contains(parts[1] + "." + parts[2] + "." + parts[3])) {
                    return parts[1] + "." + parts[2] + "." + parts[3];
                }
                if (current.getAddlWildcardThreeLvlSffxes().contains(parts[2] + "." + parts[3])) {
                    return host;
                }
                return parts[2] + "." + parts[3];
            }
            if (current.getHasTwoLvlSffxes()) {
                if (current.getExcptnlTwoLvlDomains().contains(parts[2] + "." + parts[3])) {
                    return parts[2] + "." + parts[3];
                }
                if (current.getAddlThreeLvlSffxes().contains(parts[1] + "." + parts[2] + "." + parts[3])) {
                    return host;
                }
                if (current.getExcptnlThreeLvlDomains().contains(parts[1] + "." + parts[2] + "." + parts[3])) {
                    return parts[1] + "." + parts[2] + "." + parts[3];
                }
                if (current.getAddlWildcardThreeLvlSffxes().contains(parts[2] + "." + parts[3])) {
                    return host;
                }
                return parts[1] + "." + parts[2] + "." + parts[3];
            }
            if (current.getAddlTwoLvlSffxes().contains(parts[2] + "." + parts[3])) {
                return parts[1] + "." + parts[2] + "." + parts[3];
            }
            if (current.getExcptnlThreeLvlDomains().contains(parts[1] + "." + parts[2] + "." + parts[3])) {
                return parts[1] + "." + parts[2] + "." + parts[3];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void readList(InputStream is) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        Pattern newTldP = Pattern.compile("// ([a-z][a-z]+) : .*");
        Tld current = null;
        String tld = "";
        while ((line = in.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            Matcher newTldM = newTldP.matcher(line);
            if (newTldM.matches()) {
                tld = newTldM.group(1);
                current = new Tld(tld);
                this.TLDs.put(tld, current);
                continue;
            }
            if (current == null) continue;
            if (line.equals(tld)) {
                current.setHasOneLvlSffxes();
                continue;
            }
            if (line.equals("*." + tld)) {
                current.setHasTwoLvlSffxes();
                continue;
            }
            if (line.matches("[a-z0-9-]+\\." + tld)) {
                current.addAddlTwoLvlSffx(line);
                continue;
            }
            if (line.matches("[a-z0-9-]+\\.[a-z0-9-]+\\." + tld)) {
                current.addAddlThreeLvlSffx(line);
                continue;
            }
            if (line.matches("![a-z0-9-]+\\." + tld)) {
                current.addExcptnlTwoLvlDomain(line.substring(1, line.length()));
                continue;
            }
            if (line.matches("\\*\\.[a-z0-9-]+\\." + tld)) {
                current.addAddlWildcardThreeLvlSffx(line.substring(2, line.length()));
                continue;
            }
            if (!line.matches("![a-z0-9-]+\\.[a-z0-9-]+\\." + tld)) continue;
            current.addExcptnlThreeLvlDomain(line.substring(1, line.length()));
        }
    }
}

