/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    public static final Resource RDFTYPE = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    Count<Node> _classes = new Count();
    Count<Node> _predicates = new Count();
    HashSet<Integer> _objects = new HashSet();
    HashSet<Integer> _sources = new HashSet();
    int _instances = 0;
    int _lines = 0;
    int _bnodes = 0;
    int _uris = 0;

    public void count(Iterator<Node[]> it, boolean all) throws IOException, ParseException {
        boolean done;
        Node[] quad = null;
        Node oldSub = null;
        TreeSet<Node> cons = new TreeSet<Node>();
        TreeSet<Node> types = new TreeSet<Node>();
        boolean bl = done = !it.hasNext();
        while (!done) {
            boolean bl2 = done = !it.hasNext();
            if (!done) {
                ++this._lines;
                quad = it.next();
            }
            if (this._lines % 1000000 == 0) {
                System.err.println("Done " + this._lines);
            }
            if (oldSub == null) {
                oldSub = quad[0];
            } else if (!oldSub.equals(quad[0]) || !it.hasNext()) {
                ++this._instances;
                if (oldSub instanceof BNode) {
                    ++this._bnodes;
                    for (Node n : types) {
                        this._classes.add(n);
                    }
                } else if (oldSub instanceof Resource) {
                    ++this._uris;
                    for (Node n : types) {
                        this._classes.add(n);
                    }
                } else {
                    System.err.println("oldSub is a " + oldSub.getClass().getName());
                }
                types = new TreeSet();
                oldSub = quad[0];
            }
            cons.add(quad[3]);
            if (quad[1].equals(RDFTYPE)) {
                types.add(quad[2]);
            }
            this._predicates.add(quad[1]);
            if (!all) continue;
            this._sources.add(quad[3].hashCode());
        }
    }

    public void printStats() {
        System.out.println("Number of classes " + this._classes.size());
        System.out.println("Number of subjects " + this._instances);
        System.out.println("Number of predicates " + this._predicates.size());
        System.out.println("Number of contexts " + this._sources.size());
        System.out.println("Number of quadruples " + this._lines);
        System.out.println("Number of anonymous nodes " + this._bnodes);
        System.out.println("Number of URI identified nodes " + this._uris);
    }

    public void printClasses() {
        this._classes.printStats();
    }

    public void printPredicates() {
        this._predicates.printStats();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Count<T> {
        Hashtable<T, Integer> _ht = new Hashtable();

        public void add(T id) {
            if (this._ht.containsKey(id)) {
                Integer i = this._ht.get(id);
                this._ht.put(id, new Integer(i + 1));
            } else {
                this._ht.put(id, new Integer(1));
            }
        }

        public void printStats() {
            for (Map.Entry<T, Integer> e : this._ht.entrySet()) {
                System.out.println(e.getKey() + "\t" + e.getValue());
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            for (Map.Entry<T, Integer> e : this._ht.entrySet()) {
                s.append(e.getKey() + "\t" + e.getValue() + "\n");
            }
            return s.toString();
        }

        public int size() {
            return this._ht.size();
        }
    }
}

