/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.util.NxUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NxParser
implements Iterator<Node[]>,
Iterable<Node[]> {
    private static Logger _log = Logger.getLogger(NxParser.class.getName());
    private int _lineNo = 0;
    private String _line = null;
    private Iterator<String> _stringIt = null;
    private Node[] next = null;
    @Deprecated
    public static boolean DEFAULT_PARSE_DTS = false;

    public NxParser(Reader r) {
        this(new BufferedReader(r));
    }

    public NxParser(InputStream is, Charset cs) {
        this(new BufferedReader(new InputStreamReader(is, cs)));
    }

    public NxParser(InputStream is) {
        this(new BufferedReader(new InputStreamReader(is)));
    }

    public NxParser(BufferedReader br) {
        this(NxParser.stringItFromBufferedReader(br));
    }

    public NxParser(Iterable<String> iterable) {
        this(iterable.iterator());
    }

    public NxParser(Iterator<String> iterator) {
        this._stringIt = iterator;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Node[] next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Node[] now = this.next;
        this.loadNext();
        return now;
    }

    private void loadNext() {
        this.next = null;
        do {
            if (!this._stringIt.hasNext()) {
                this.next = null;
                return;
            }
            this._line = this._stringIt.next();
            ++this._lineNo;
        } while (this._line == null || NxParser.isEntirelyWhitespaceOrEmpty(this._line));
        try {
            this.next = NxParser.parseNodesInternal(this._line);
        }
        catch (Exception e) {
            _log.warning("Moving on to the next line, as I couldn't parse line " + this._lineNo + ": " + this._line);
            e.printStackTrace();
            this.loadNext();
        }
        if (this.next.length == 0) {
            this.loadNext();
        }
    }

    private static boolean isEntirelyWhitespaceOrEmpty(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        this._stringIt.remove();
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }

    public static Node[] parseNodes(String line) throws ParseException {
        try {
            return NxParser.parseNodesInternal(line);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Node[] parseNodesInternal(String line) throws ParseException {
        int startIndex = 0;
        int endIndex = 0;
        LinkedList<Node> nx = new LinkedList<Node>();
        if (line.isEmpty()) {
            return new Node[0];
        }
        while (true) {
            if (Character.isWhitespace(line.charAt(startIndex))) {
                ++endIndex;
                if (++startIndex != line.length()) continue;
                if (!nx.isEmpty()) throw new ParseException("Could not find closing '.' bracket for line " + line);
                return new Node[0];
            }
            if (line.charAt(startIndex) == '<') {
                endIndex = line.indexOf("> ", startIndex) + 1;
                if (endIndex == 0) {
                    throw new ParseException("Could not find closing '>' bracket for resource starting at char " + startIndex + " while parsing line " + line);
                }
                nx.add(new Resource(line.substring(startIndex, endIndex), true));
            } else if (line.charAt(startIndex) == '_') {
                endIndex = line.indexOf(32, startIndex);
                nx.add(new BNode(line.substring(startIndex, endIndex), true));
            } else {
                if (line.charAt(startIndex) == '.') {
                    if (nx.isEmpty()) {
                        throw new ParseException("Exception at position " + startIndex + " while parsing: '" + line + "'");
                    }
                    for (int i = startIndex + 1; i < line.length(); ++i) {
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        throw new ParseException("Exception at position " + i + " while parsing: '" + line + "'");
                    }
                    return nx.toArray(new Node[nx.size()]);
                }
                if (line.charAt(startIndex) == '\"') {
                    endIndex = startIndex;
                    while (line.charAt((endIndex = line.indexOf(34, endIndex + 1)) - 1) == '\\' && (endIndex - 1 - NxParser.onlyCharUntil(line, '\\', endIndex - 1)) % 2 == 0) {
                    }
                    while (line.charAt(endIndex) != ' ') {
                        ++endIndex;
                    }
                    nx.add(new Literal(line.substring(startIndex, endIndex), true));
                } else {
                    if (line.charAt(startIndex) == '#' && nx.isEmpty()) {
                        return new Node[0];
                    }
                    if (line.charAt(startIndex) == '?') {
                        endIndex = line.indexOf(32, startIndex);
                        nx.add(new Variable(line.substring(startIndex, endIndex), true));
                    } else {
                        if (line.charAt(startIndex) != "UNBOUND".charAt(0)) throw new ParseException("Exception at position " + endIndex + " while parsing: '" + line + "'");
                        if (!line.substring(startIndex, startIndex + "UNBOUND".length()).equals("UNBOUND")) throw new ParseException("Exception at position " + endIndex + " while parsing: '" + line + "'");
                        nx.add(new Unbound());
                        endIndex = startIndex + "UNBOUND".length();
                        if (endIndex >= line.length() || line.charAt(endIndex) != ' ') {
                            throw new ParseException("Exception at position " + startIndex + " while parsing: '" + line + "'");
                        }
                    }
                }
            }
            startIndex = endIndex + 1;
        }
    }

    private static int onlyCharUntil(String line, char c, int i) {
        while (line.charAt(i) == c) {
            --i;
        }
        return i + 1;
    }

    private static Iterator<String> stringItFromBufferedReader(final BufferedReader br) {
        return new Iterator<String>(){
            boolean nextIsFetched = true;
            String next = null;

            @Override
            public boolean hasNext() {
                if (!this.nextIsFetched) {
                    return this.next != null;
                }
                try {
                    this.next = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.next = null;
                }
                this.nextIsFetched = false;
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.nextIsFetched) {
                    try {
                        this.next = br.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.nextIsFetched = true;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int lineNumber() {
        return this._lineNo;
    }

    @Deprecated
    public NxParser(Reader r, boolean strict) {
        this(r);
    }

    @Deprecated
    public NxParser(Reader r, boolean strict, boolean parseDts) {
        this(r);
    }

    @Deprecated
    public NxParser(InputStream is, boolean strict, boolean parseDts) {
        this(is);
    }

    @Deprecated
    public NxParser(InputStream is, boolean strict) {
        this(is);
    }

    @Deprecated
    public static Node[] parseNodes(String line, boolean parseDts) throws ParseException {
        return NxParser.parseNodes(line);
    }

    @Deprecated
    public static Literal parseLiteral(String str) throws ParseException {
        return NxParser.parseLiteral(str, DEFAULT_PARSE_DTS);
    }

    @Deprecated
    public static Literal parseLiteral(String str, boolean parseDTs) throws ParseException {
        if (str.charAt(0) != '\"') {
            throw new ParseException("literal must be enclosed with \"\"");
        }
        return new Literal(str, true);
    }

    @Deprecated
    public static Variable parseVariable(String str) throws ParseException {
        if (str.charAt(0) != '?') {
            throw new ParseException("variable must start with ?");
        }
        return new Variable(str, true);
    }

    @Deprecated
    public static Resource parseResource(String str) throws ParseException {
        if (str.charAt(0) != '<' && str.charAt(str.length() - 1) != '>') {
            throw new ParseException("resource must be enclosed with <>");
        }
        return new Resource(str, true);
    }

    @Deprecated
    public static BNode parseBNode(String str) throws ParseException {
        if (str.charAt(0) != '_' || str.charAt(1) != ':') {
            throw new ParseException("bnode must start with :_");
        }
        return new BNode(str, true);
    }

    @Deprecated
    public static Node parseNode(String str) throws ParseException {
        return NxParser.parseNode(str, DEFAULT_PARSE_DTS);
    }

    @Deprecated
    public static Node parseNode(String str, boolean parseDts) throws ParseException {
        if (str.charAt(0) == '_') {
            return NxParser.parseBNode(str);
        }
        if (str.charAt(0) == '<') {
            return NxParser.parseResource(str);
        }
        if (str.charAt(0) == '\"') {
            return NxParser.parseLiteral(str, parseDts);
        }
        if (str.charAt(0) == '?') {
            return NxParser.parseVariable(str);
        }
        throw new ParseException("cannot parse " + str);
    }

    @Deprecated
    public static String escapeForNx(String lit) {
        return NxUtil.escapeForNx(lit);
    }

    @Deprecated
    public static String escapeForMarkup(String lit) {
        return NxUtil.escapeForMarkup(lit);
    }

    @Deprecated
    public static String unescape(String str) {
        return NxUtil.unescape(str, false);
    }

    @Deprecated
    public static String unescape(String str, boolean clean) {
        return NxUtil.unescape(str, clean);
    }

    public static void main(String[] args) throws ParseException {
        System.err.println(Nodes.toN3(NxParser.parseNodes("")));
    }
}

