/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.filter;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Node;

public interface NodeFilter {
    public boolean check(Node var1);

    public static class OrFilter
    implements NodeFilter {
        NodeFilter[] _filters;

        public OrFilter(NodeFilter ... filters) {
            this._filters = filters;
        }

        public boolean check(Node n) {
            for (NodeFilter filter : this._filters) {
                if (!filter.check(n)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndFilter
    implements NodeFilter {
        NodeFilter[] _filters;

        public AndFilter(NodeFilter ... filters) {
            this._filters = filters;
        }

        public boolean check(Node n) {
            for (NodeFilter filter : this._filters) {
                if (filter.check(n)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassFilter
    extends AbstractFilter {
        Class<? extends Node> _class;

        public ClassFilter(Class<? extends Node> c) {
            this(c, false);
        }

        public ClassFilter(Class<? extends Node> c, boolean negate) {
            super(negate);
            this._class = c;
        }

        @Override
        protected boolean matches(Node n) {
            return this._class.isInstance(n);
        }
    }

    public static class RegexFilter
    extends AbstractFilter {
        Pattern _pattern;
        public static final char CASE_INSENSITIVE = 'i';
        public static final char DOT_ALL = 's';
        public static final char MULTI_LINE = 'm';
        public static final char REMOVE_WHITESPACE = 'x';

        public RegexFilter(String pattern, int flagMask) {
            this(pattern, flagMask, false);
        }

        public RegexFilter(String pattern, int flagMask, boolean negate) {
            super(negate);
            this._pattern = Pattern.compile(pattern, flagMask);
        }

        public RegexFilter(String pattern) {
            this(pattern, false);
        }

        public RegexFilter(String pattern, boolean negate) {
            super(negate);
            this._pattern = Pattern.compile(pattern);
        }

        protected boolean matches(Node n) {
            return this._pattern.matcher(n.toString()).matches();
        }

        public RegexFilter(String pattern, String flag) {
            this(pattern, flag, false);
        }

        public RegexFilter(String pattern, String flag, boolean negate) {
            super(negate);
            if (flag != null && flag.trim().length() > 0) {
                flag = flag.trim();
                int[] flags = new int[flag.length()];
                for (int i = 0; i < flag.length(); ++i) {
                    char c = flag.charAt(i);
                    if (c == 'i') {
                        flags[i] = 2;
                        continue;
                    }
                    if (c == 's') {
                        flags[i] = 32;
                        continue;
                    }
                    if (c == 'm') {
                        flags[i] = 8;
                        continue;
                    }
                    if (c == 'x') {
                        flags[i] = 4;
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot recognise REGEX flag :" + flag + "." + "Must be " + 'i' + " " + 's' + " " + 'm' + " or " + 'x');
                }
                int bm = 0;
                if (flags != null && flags.length != 0) {
                    if (flags.length == 1) {
                        bm = flags[0];
                    } else {
                        bm = flags[0];
                        for (int i = 1; i < flags.length; ++i) {
                            bm |= flags[i];
                        }
                    }
                }
                this._pattern = Pattern.compile(pattern, bm);
            } else {
                this._pattern = Pattern.compile(pattern);
            }
        }
    }

    public static class PrefixFilter
    extends AbstractFilter {
        String _namespace;

        public PrefixFilter(String ns) {
            this(ns, false);
        }

        public PrefixFilter(String ns, boolean negate) {
            super(negate);
            this._namespace = ns;
        }

        protected boolean matches(Node n) {
            return n.toString().startsWith(this._namespace);
        }
    }

    public static class EqualsFilter
    extends AbstractFilter {
        String _equals;

        public EqualsFilter(String n, boolean negate) {
            super(negate);
            this._equals = n;
        }

        public EqualsFilter(String n) {
            this(n, false);
        }

        protected boolean matches(Node n) {
            return this._equals.equals(n.toString());
        }
    }

    public static abstract class AbstractFilter
    implements NodeFilter {
        boolean _negate;

        protected AbstractFilter(boolean negate) {
            this._negate = negate;
        }

        protected AbstractFilter() {
            this._negate = false;
        }

        public final boolean check(Node n) {
            return this._negate ^ this.matches(n);
        }

        protected abstract boolean matches(Node var1);
    }
}

