/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.filter.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator
implements Iterator<Node[]> {
    private Iterator<Node[]> _in;
    private NodeFilter[] _nf;
    private Node[] _current;

    public FilterIterator(Iterator<Node[]> in, NodeFilter[] nf) {
        this._in = in;
        this._nf = nf;
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public Node[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] old = this._current;
        this.getNext();
        return old;
    }

    private void getNext() {
        this._current = null;
        if (!this._in.hasNext()) {
            return;
        }
        while (this._in.hasNext()) {
            Node[] ns = this._in.next();
            if (!FilterIterator.check(this._nf, ns)) continue;
            this._current = ns;
            return;
        }
    }

    public static boolean check(NodeFilter[] nfs, Node[] ns) {
        if (nfs == null) {
            return true;
        }
        for (int i = 0; i < nfs.length; ++i) {
            NodeFilter f = nfs[i];
            if (f == null || f.check(ns[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

