/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDUnsignedShort
extends Datatype<Integer> {
    public static final Resource DT = XSD.UNSIGNEDSHORT;
    private Integer _us;
    private static final int MAX_INCLUSIVE = 65535;
    private static final int MIN_INCLUSIVE = 0;
    public static final String REGEX = "(\\+|-)?[0-9]+";

    public XSDUnsignedShort(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?[0-9]+.", s, DT, 20);
        }
        try {
            if (s.startsWith("+")) {
                s = s.substring(1, s.length());
            }
            this._us = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing int (unsigned short): " + e.getMessage() + ".", s, DT, 40);
        }
        if (this._us.compareTo(65535) > 0) {
            throw new DatatypeParseException("Value of unsigned short above max_inclusive value 65535.", s, DT, 41);
        }
        if (this._us.compareTo(0) < 0) {
            throw new DatatypeParseException("Value of unsigned short below min_inclusive value 0.", s, DT, 42);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._us.toString();
    }

    @Override
    public Integer getValue() {
        return this._us;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDUnsignedShort dec = new XSDUnsignedShort("23425");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

