/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDUnsignedLong
extends Datatype<BigInteger> {
    public static final Resource DT = XSD.UNSIGNEDLONG;
    private BigInteger _ul;
    private static final BigInteger MAX_INCLUSIVE = new BigInteger("18446744073709551615");
    private static final BigInteger MIN_INCLUSIVE = new BigInteger("0");
    public static final String REGEX = "(\\+|-)?[0-9]+";

    public XSDUnsignedLong(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?[0-9]+.", s, DT, 20);
        }
        try {
            if (s.startsWith("+")) {
                s = s.substring(1, s.length());
            }
            this._ul = new BigInteger(s);
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing BigInteger (unsigned long): " + e.getMessage() + ".", s, DT, 21);
        }
        if (this._ul.compareTo(MAX_INCLUSIVE) > 0) {
            throw new DatatypeParseException("Value of unsigned long above max_inclusive value " + MAX_INCLUSIVE + ".", s, DT, 40);
        }
        if (this._ul.compareTo(MIN_INCLUSIVE) < 0) {
            throw new DatatypeParseException("Value of unsigned long below min_inclusive value " + MIN_INCLUSIVE + ".", s, DT, 42);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ul.toString();
    }

    @Override
    public BigInteger getValue() {
        return this._ul;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDUnsignedLong dec = new XSDUnsignedLong("+2345276324514325326532514321");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

