/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDShort
extends Datatype<Short> {
    public static final Resource DT = XSD.SHORT;
    private short _s;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDShort(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", s, DT, 2);
        }
        try {
            this._s = !s.startsWith("+") ? Short.parseShort(s) : Short.parseShort(s.substring(1));
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing short: " + e.getMessage() + ".", s, DT, 4);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Short.toString(this._s);
    }

    @Override
    public Short getValue() {
        return this._s;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDShort dec = new XSDShort("-32767");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

