/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDByte
extends Datatype<Byte> {
    public static final Resource DT = XSD.BYTE;
    private byte _b;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDByte(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", s, DT, 20);
        }
        try {
            this._b = !s.startsWith("+") ? Byte.parseByte(s) : Byte.parseByte(s.substring(1));
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing byte: " + e.getMessage() + ".", s, DT, 21);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Byte.toString(this._b);
    }

    @Override
    public Byte getValue() {
        return this._b;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDByte dec = new XSDByte("-67");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

