/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.datetime;

import java.util.GregorianCalendar;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.datetime.ISO8601Parser;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDTime
extends Datatype<GregorianCalendar> {
    public static final Resource DT = XSD.TIME;
    private GregorianCalendar _cal;

    public XSDTime(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        try {
            this._cal = ISO8601Parser.parseISO8601Time(s);
        }
        catch (DatatypeParseException e) {
            throw new DatatypeParseException(e.getMessage(), s, DT, e.getError());
        }
    }

    @Override
    public GregorianCalendar getValue() {
        return this._cal;
    }

    @Override
    public String getCanonicalRepresentation() {
        return ISO8601Parser.getCanonicalRepresentation(this.getValue(), false, false, false, true, true);
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDTime dt = new XSDTime("23:34:45+05:00");
        System.err.println(dt.getCanonicalRepresentation());
    }

    public static String removeTrailingZeros(String s) {
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

