/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt;

import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.binary.XSDBase64Binary;
import org.semanticweb.yars.nx.dt.binary.XSDHexBinary;
import org.semanticweb.yars.nx.dt.bool.XSDBoolean;
import org.semanticweb.yars.nx.dt.datetime.XSDDate;
import org.semanticweb.yars.nx.dt.datetime.XSDDateTime;
import org.semanticweb.yars.nx.dt.datetime.XSDDateTimeStamp;
import org.semanticweb.yars.nx.dt.datetime.XSDGDay;
import org.semanticweb.yars.nx.dt.datetime.XSDGMonth;
import org.semanticweb.yars.nx.dt.datetime.XSDGMonthDay;
import org.semanticweb.yars.nx.dt.datetime.XSDGYear;
import org.semanticweb.yars.nx.dt.datetime.XSDGYearMonth;
import org.semanticweb.yars.nx.dt.datetime.XSDTime;
import org.semanticweb.yars.nx.dt.numeric.XSDByte;
import org.semanticweb.yars.nx.dt.numeric.XSDDecimal;
import org.semanticweb.yars.nx.dt.numeric.XSDDouble;
import org.semanticweb.yars.nx.dt.numeric.XSDFloat;
import org.semanticweb.yars.nx.dt.numeric.XSDInt;
import org.semanticweb.yars.nx.dt.numeric.XSDInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDLong;
import org.semanticweb.yars.nx.dt.numeric.XSDNegativeInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDNonNegativeInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDNonPositiveInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDPositiveInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDShort;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedByte;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedInt;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedLong;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedShort;
import org.semanticweb.yars.nx.dt.string.XSDLanguage;
import org.semanticweb.yars.nx.dt.string.XSDNCName;
import org.semanticweb.yars.nx.dt.string.XSDNMToken;
import org.semanticweb.yars.nx.dt.string.XSDName;
import org.semanticweb.yars.nx.dt.string.XSDNormalisedString;
import org.semanticweb.yars.nx.dt.string.XSDString;
import org.semanticweb.yars.nx.dt.string.XSDToken;
import org.semanticweb.yars.nx.dt.uri.XSDAnyURI;
import org.semanticweb.yars.nx.dt.xml.RDFXMLLiteral;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeFactory {
    public static Datatype<? extends Object> getDatatype(Literal l) throws DatatypeParseException {
        return DatatypeFactory.getDatatype(l.getUnescapedData(), l.getDatatype());
    }

    public static Datatype<? extends Object> getDatatype(String lex, Resource dt) throws DatatypeParseException {
        if (dt == null || lex == null) {
            return null;
        }
        if (dt.toString().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            if (dt.equals(XSD.STRING)) {
                return new XSDString(lex);
            }
            if (dt.equals(XSD.BOOLEAN)) {
                return new XSDBoolean(lex);
            }
            if (dt.equals(XSD.INTEGER)) {
                return new XSDInteger(lex);
            }
            if (dt.equals(XSD.DATETIME)) {
                return new XSDDateTime(lex);
            }
            if (dt.equals(XSD.DATETIMESTAMP)) {
                return new XSDDateTimeStamp(lex);
            }
            if (dt.equals(XSD.DATE)) {
                return new XSDDate(lex);
            }
            if (dt.equals(XSD.TIME)) {
                return new XSDTime(lex);
            }
            if (dt.equals(XSD.INT)) {
                return new XSDInt(lex);
            }
            if (dt.equals(XSD.LONG)) {
                return new XSDLong(lex);
            }
            if (dt.equals(XSD.SHORT)) {
                return new XSDShort(lex);
            }
            if (dt.equals(XSD.BYTE)) {
                return new XSDByte(lex);
            }
            if (dt.equals(XSD.DECIMAL)) {
                return new XSDDecimal(lex);
            }
            if (dt.equals(XSD.FLOAT)) {
                return new XSDFloat(lex);
            }
            if (dt.equals(XSD.DOUBLE)) {
                return new XSDDouble(lex);
            }
            if (dt.equals(XSD.GYEARMONTH)) {
                return new XSDGYearMonth(lex);
            }
            if (dt.equals(XSD.GYEAR)) {
                return new XSDGYear(lex);
            }
            if (dt.equals(XSD.GMONTHDAY)) {
                return new XSDGMonthDay(lex);
            }
            if (dt.equals(XSD.GMONTH)) {
                return new XSDGMonth(lex);
            }
            if (dt.equals(XSD.GDAY)) {
                return new XSDGDay(lex);
            }
            if (dt.equals(XSD.HEXBINARY)) {
                return new XSDHexBinary(lex);
            }
            if (dt.equals(XSD.BASE64BINARY)) {
                return new XSDBase64Binary(lex);
            }
            if (dt.equals(XSD.TOKEN)) {
                return new XSDToken(lex);
            }
            if (dt.equals(XSD.NMTOKEN)) {
                return new XSDNMToken(lex);
            }
            if (dt.equals(XSD.NAME)) {
                return new XSDName(lex);
            }
            if (dt.equals(XSD.NCNAME)) {
                return new XSDNCName(lex);
            }
            if (dt.equals(XSD.NONNEGATIVEINTEGER)) {
                return new XSDNonNegativeInteger(lex);
            }
            if (dt.equals(XSD.POSITIVEINTEGER)) {
                return new XSDPositiveInteger(lex);
            }
            if (dt.equals(XSD.NONPOSITIVEINTEGER)) {
                return new XSDNonPositiveInteger(lex);
            }
            if (dt.equals(XSD.NEGATIVEINTEGER)) {
                return new XSDNegativeInteger(lex);
            }
            if (dt.equals(XSD.NORMALIZEDSTRING)) {
                return new XSDNormalisedString(lex);
            }
            if (dt.equals(XSD.ANYURI)) {
                return new XSDAnyURI(lex);
            }
            if (dt.equals(XSD.LANGUAGE)) {
                return new XSDLanguage(lex);
            }
            if (dt.equals(XSD.UNSIGNEDLONG)) {
                return new XSDUnsignedLong(lex);
            }
            if (dt.equals(XSD.UNSIGNEDINT)) {
                return new XSDUnsignedInt(lex);
            }
            if (dt.equals(XSD.UNSIGNEDSHORT)) {
                return new XSDUnsignedShort(lex);
            }
            if (dt.equals(XSD.UNSIGNEDBYTE)) {
                return new XSDUnsignedByte(lex);
            }
        } else if (dt.equals(RDF.XMLLITERAL)) {
            return new RDFXMLLiteral(lex);
        }
        return null;
    }

    public static void main(String[] args) throws DatatypeParseException {
        System.err.println(DatatypeFactory.getDatatype("2005-03-04", XSD.DATETIME));
    }
}

