/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

public class Sample {
    public static void main(String[] args) throws IOException, ParseException {
        Option inputO = new Option("i", "name of file to read, - for stdin");
        inputO.setArgs(1);
        Option outputO = new Option("o", "name of file to write, - for stdout");
        outputO.setArgs(1);
        Option helpO = new Option("h", "print help");
        Option sampleO = new Option("s", "sample factor ]0..1[");
        sampleO.setArgs(1);
        sampleO.setRequired(true);
        Options options = new Options();
        options.addOption(inputO);
        options.addOption(outputO);
        options.addOption(helpO);
        options.addOption(sampleO);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            System.err.println("***ERROR: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        InputStream in = System.in;
        PrintStream out = System.out;
        if (cmd.hasOption("i")) {
            in = cmd.getOptionValue("i").equals("-") ? System.in : new FileInputStream(cmd.getOptionValue("i"));
        }
        if (cmd.hasOption("o")) {
            out = cmd.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(cmd.getOptionValue("o")));
        }
        float sample = Float.parseFloat(cmd.getOptionValue("s"));
        Random r = new Random();
        NxParser nxp = new NxParser(in);
        while (nxp.hasNext()) {
            Node[] nx = nxp.next();
            float rf = r.nextFloat();
            if (!(rf <= sample)) continue;
            out.print(Nodes.toN3(nx));
            out.println();
        }
    }
}

